/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * CompletedMultipartUpload StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CompletedMultipartUploadUnmarshaller implements Unmarshaller<CompletedMultipartUpload, StaxUnmarshallerContext> {

    public CompletedMultipartUpload unmarshall(StaxUnmarshallerContext context) throws Exception {
        CompletedMultipartUpload.Builder completedMultipartUpload = CompletedMultipartUpload.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<CompletedPart> parts = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                completedMultipartUpload.parts(parts);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Part", targetDepth)) {
                    if (parts == null) {
                        parts = new ArrayList<>();
                    }
                    parts.add(CompletedPartUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    completedMultipartUpload.parts(parts);
                    break;
                }
            }
        }
        return completedMultipartUpload.build();
    }

    private static final CompletedMultipartUploadUnmarshaller INSTANCE = new CompletedMultipartUploadUnmarshaller();

    public static CompletedMultipartUploadUnmarshaller getInstance() {
        return INSTANCE;
    }
}
