/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.io.ByteArrayInputStream;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * CreateMultipartUploadRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateMultipartUploadRequestMarshaller implements
        Marshaller<Request<CreateMultipartUploadRequest>, CreateMultipartUploadRequest> {

    public Request<CreateMultipartUploadRequest> marshall(CreateMultipartUploadRequest createMultipartUploadRequest) {

        if (createMultipartUploadRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<CreateMultipartUploadRequest> request = new DefaultRequest<CreateMultipartUploadRequest>(
                createMultipartUploadRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.POST);

        if (createMultipartUploadRequest.aclString() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString(createMultipartUploadRequest.aclString()));
        }

        if (createMultipartUploadRequest.cacheControl() != null) {
            request.addHeader("Cache-Control", StringUtils.fromString(createMultipartUploadRequest.cacheControl()));
        }

        if (createMultipartUploadRequest.contentDisposition() != null) {
            request.addHeader("Content-Disposition", StringUtils.fromString(createMultipartUploadRequest.contentDisposition()));
        }

        if (createMultipartUploadRequest.contentEncoding() != null) {
            request.addHeader("Content-Encoding", StringUtils.fromString(createMultipartUploadRequest.contentEncoding()));
        }

        if (createMultipartUploadRequest.contentLanguage() != null) {
            request.addHeader("Content-Language", StringUtils.fromString(createMultipartUploadRequest.contentLanguage()));
        }

        if (createMultipartUploadRequest.contentType() != null) {
            request.addHeader("Content-Type", StringUtils.fromString(createMultipartUploadRequest.contentType()));
        }

        if (createMultipartUploadRequest.expires() != null) {
            request.addHeader("Expires", StringUtils.fromInstant(createMultipartUploadRequest.expires()));
        }

        if (createMultipartUploadRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString(createMultipartUploadRequest.grantFullControl()));
        }

        if (createMultipartUploadRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString(createMultipartUploadRequest.grantRead()));
        }

        if (createMultipartUploadRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString(createMultipartUploadRequest.grantReadACP()));
        }

        if (createMultipartUploadRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString(createMultipartUploadRequest.grantWriteACP()));
        }

        if (createMultipartUploadRequest.serverSideEncryptionString() != null) {
            request.addHeader("x-amz-server-side-encryption",
                    StringUtils.fromString(createMultipartUploadRequest.serverSideEncryptionString()));
        }

        if (createMultipartUploadRequest.storageClassString() != null) {
            request.addHeader("x-amz-storage-class", StringUtils.fromString(createMultipartUploadRequest.storageClassString()));
        }

        if (createMultipartUploadRequest.websiteRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location",
                    StringUtils.fromString(createMultipartUploadRequest.websiteRedirectLocation()));
        }

        if (createMultipartUploadRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringUtils.fromString(createMultipartUploadRequest.sseCustomerAlgorithm()));
        }

        if (createMultipartUploadRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringUtils.fromString(createMultipartUploadRequest.sseCustomerKey()));
        }

        if (createMultipartUploadRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringUtils.fromString(createMultipartUploadRequest.sseCustomerKeyMD5()));
        }

        if (createMultipartUploadRequest.ssekmsKeyId() != null) {
            request.addHeader("x-amz-server-side-encryption-aws-kms-key-id",
                    StringUtils.fromString(createMultipartUploadRequest.ssekmsKeyId()));
        }

        if (createMultipartUploadRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(createMultipartUploadRequest.requestPayerString()));
        }

        if (createMultipartUploadRequest.metadata() != null) {
            createMultipartUploadRequest.metadata().entrySet().forEach(e -> {
                if (e.getKey().startsWith("x-amz-meta-")) {
                    request.addHeader(e.getKey(), e.getValue());
                } else {
                    request.addHeader("x-amz-meta-" + e.getKey(), e.getValue());
                }
            });
        }

        String uriResourcePath = "/{Bucket}/{Key+}?uploads";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", createMultipartUploadRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                createMultipartUploadRequest.key());
        request.setResourcePath(uriResourcePath);

        request.setContent(new ByteArrayInputStream(new byte[0]));
        request.addHeader("Content-Length", String.valueOf(0));

        return request;
    }

}