/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DeleteObjectsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DeleteObjectsResponseUnmarshaller implements Unmarshaller<DeleteObjectsResponse, StaxUnmarshallerContext> {

    public DeleteObjectsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DeleteObjectsResponse.Builder deleteObjectsResponse = DeleteObjectsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-request-charged");
            deleteObjectsResponse.requestCharged(StringUnmarshaller.getInstance().unmarshall(context));

        }

        java.util.List<DeletedObject> deleted = null;
        java.util.List<S3Error> errors = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                deleteObjectsResponse.deleted(deleted);
                deleteObjectsResponse.errors(errors);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Deleted", targetDepth)) {
                    if (deleted == null) {
                        deleted = new ArrayList<>();
                    }
                    deleted.add(DeletedObjectUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Error", targetDepth)) {
                    if (errors == null) {
                        errors = new ArrayList<>();
                    }
                    errors.add(S3ErrorUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    deleteObjectsResponse.deleted(deleted);
                    deleteObjectsResponse.errors(errors);
                    break;
                }
            }
        }
        return deleteObjectsResponse.build();
    }

    private static final DeleteObjectsResponseUnmarshaller INSTANCE = new DeleteObjectsResponseUnmarshaller();

    public static DeleteObjectsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
