/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.Map;
import java.util.HashMap;

import java.util.Map.Entry;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.core.runtime.transform.MapEntry;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * GetObjectResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetObjectResponseUnmarshaller implements Unmarshaller<GetObjectResponse, StaxUnmarshallerContext> {

    private static class MetadataMapEntryUnmarshaller implements Unmarshaller<Map.Entry<String, String>, StaxUnmarshallerContext> {

        @Override
        public Entry<String, String> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;

            MapEntry<String, String> entry = new MapEntry<String, String>();

            while (true) {
                XMLEvent xmlEvent = context.nextEvent();
                if (xmlEvent.isEndDocument())
                    return entry;

                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("value", targetDepth)) {
                        entry.setValue(StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                } else if (xmlEvent.isEndElement()) {
                    if (context.getCurrentDepth() < originalDepth)
                        return entry;
                }
            }
        }

        private static final MetadataMapEntryUnmarshaller INSTANCE = new MetadataMapEntryUnmarshaller();

        public static MetadataMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }

    }

    public GetObjectResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        GetObjectResponse.Builder getObjectResponse = GetObjectResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument()) {
            context.setCurrentHeader("x-amz-delete-marker");
            getObjectResponse.deleteMarker(BooleanUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("accept-ranges");
            getObjectResponse.acceptRanges(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-expiration");
            getObjectResponse.expiration(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-restore");
            getObjectResponse.restore(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Last-Modified");
            getObjectResponse.lastModified(software.amazon.awssdk.core.util.DateUtils.parseRfc1123Date(context.readText()));

            context.setCurrentHeader("Content-Length");
            getObjectResponse.contentLength(LongUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("ETag");
            getObjectResponse.eTag(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-missing-meta");
            getObjectResponse.missingMeta(IntegerUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-version-id");
            getObjectResponse.versionId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Cache-Control");
            getObjectResponse.cacheControl(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Content-Disposition");
            getObjectResponse.contentDisposition(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Content-Encoding");
            getObjectResponse.contentEncoding(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Content-Language");
            getObjectResponse.contentLanguage(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Content-Range");
            getObjectResponse.contentRange(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Content-Type");
            getObjectResponse.contentType(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("Expires");
            getObjectResponse.expires(software.amazon.awssdk.core.util.DateUtils.parseRfc1123Date(context.readText()));

            context.setCurrentHeader("x-amz-website-redirect-location");
            getObjectResponse.websiteRedirectLocation(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption");
            getObjectResponse.serverSideEncryption(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-algorithm");
            getObjectResponse.sseCustomerAlgorithm(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-customer-key-MD5");
            getObjectResponse.sseCustomerKeyMD5(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-server-side-encryption-aws-kms-key-id");
            getObjectResponse.ssekmsKeyId(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-storage-class");
            getObjectResponse.storageClass(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-request-charged");
            getObjectResponse.requestCharged(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-replication-status");
            getObjectResponse.replicationStatus(StringUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-mp-parts-count");
            getObjectResponse.partsCount(IntegerUnmarshaller.getInstance().unmarshall(context));

            context.setCurrentHeader("x-amz-tagging-count");
            getObjectResponse.tagCount(IntegerUnmarshaller.getInstance().unmarshall(context));

        }

        Map<String, String> metadata = new HashMap<>();
        context.getHeaders().entrySet().stream().filter(e -> e.getKey().startsWith("x-amz-meta-")).forEach(e -> {
            metadata.put(e.getKey().replace("x-amz-meta-", ""), e.getValue());
        });
        getObjectResponse.metadata(metadata);

        return getObjectResponse.build();
    }

    private static final GetObjectResponseUnmarshaller INSTANCE = new GetObjectResponseUnmarshaller();

    public static GetObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
