/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListMultipartUploadsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListMultipartUploadsRequestMarshaller implements
        Marshaller<Request<ListMultipartUploadsRequest>, ListMultipartUploadsRequest> {

    public Request<ListMultipartUploadsRequest> marshall(ListMultipartUploadsRequest listMultipartUploadsRequest) {

        if (listMultipartUploadsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListMultipartUploadsRequest> request = new DefaultRequest<ListMultipartUploadsRequest>(
                listMultipartUploadsRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        String uriResourcePath = "/{Bucket}?uploads";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", listMultipartUploadsRequest.bucket());
        request.setResourcePath(uriResourcePath);

        if (listMultipartUploadsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString(listMultipartUploadsRequest.delimiter()));
        }

        if (listMultipartUploadsRequest.encodingTypeString() != null) {
            request.addParameter("encoding-type", StringUtils.fromString(listMultipartUploadsRequest.encodingTypeString()));
        }

        if (listMultipartUploadsRequest.keyMarker() != null) {
            request.addParameter("key-marker", StringUtils.fromString(listMultipartUploadsRequest.keyMarker()));
        }

        if (listMultipartUploadsRequest.maxUploads() != null) {
            request.addParameter("max-uploads", StringUtils.fromInteger(listMultipartUploadsRequest.maxUploads()));
        }

        if (listMultipartUploadsRequest.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString(listMultipartUploadsRequest.prefix()));
        }

        if (listMultipartUploadsRequest.uploadIdMarker() != null) {
            request.addParameter("upload-id-marker", StringUtils.fromString(listMultipartUploadsRequest.uploadIdMarker()));
        }

        return request;
    }

}