/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListObjectsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListObjectsRequestMarshaller implements Marshaller<Request<ListObjectsRequest>, ListObjectsRequest> {

    public Request<ListObjectsRequest> marshall(ListObjectsRequest listObjectsRequest) {

        if (listObjectsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListObjectsRequest> request = new DefaultRequest<ListObjectsRequest>(listObjectsRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        if (listObjectsRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(listObjectsRequest.requestPayerString()));
        }

        String uriResourcePath = "/{Bucket}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", listObjectsRequest.bucket());
        request.setResourcePath(uriResourcePath);

        if (listObjectsRequest.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString(listObjectsRequest.delimiter()));
        }

        if (listObjectsRequest.encodingTypeString() != null) {
            request.addParameter("encoding-type", StringUtils.fromString(listObjectsRequest.encodingTypeString()));
        }

        if (listObjectsRequest.marker() != null) {
            request.addParameter("marker", StringUtils.fromString(listObjectsRequest.marker()));
        }

        if (listObjectsRequest.maxKeys() != null) {
            request.addParameter("max-keys", StringUtils.fromInteger(listObjectsRequest.maxKeys()));
        }

        if (listObjectsRequest.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString(listObjectsRequest.prefix()));
        }

        return request;
    }

}