/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListObjectsResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListObjectsResponseUnmarshaller implements Unmarshaller<ListObjectsResponse, StaxUnmarshallerContext> {

    public ListObjectsResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListObjectsResponse.Builder listObjectsResponse = ListObjectsResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<S3Object> contents = null;
        java.util.List<CommonPrefix> commonPrefixes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listObjectsResponse.contents(contents);
                listObjectsResponse.commonPrefixes(commonPrefixes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listObjectsResponse.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Marker", targetDepth)) {
                    listObjectsResponse.marker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextMarker", targetDepth)) {
                    listObjectsResponse.nextMarker(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Contents", targetDepth)) {
                    if (contents == null) {
                        contents = new ArrayList<>();
                    }
                    contents.add(S3ObjectUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Name", targetDepth)) {
                    listObjectsResponse.name(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Prefix", targetDepth)) {
                    listObjectsResponse.prefix(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Delimiter", targetDepth)) {
                    listObjectsResponse.delimiter(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxKeys", targetDepth)) {
                    listObjectsResponse.maxKeys(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CommonPrefixes", targetDepth)) {
                    if (commonPrefixes == null) {
                        commonPrefixes = new ArrayList<>();
                    }
                    commonPrefixes.add(CommonPrefixUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EncodingType", targetDepth)) {
                    listObjectsResponse.encodingType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listObjectsResponse.contents(contents);
                    listObjectsResponse.commonPrefixes(commonPrefixes);
                    break;
                }
            }
        }
        return listObjectsResponse.build();
    }

    private static final ListObjectsResponseUnmarshaller INSTANCE = new ListObjectsResponseUnmarshaller();

    public static ListObjectsResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
