/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * ListObjectsV2Request Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListObjectsV2RequestMarshaller implements Marshaller<Request<ListObjectsV2Request>, ListObjectsV2Request> {

    public Request<ListObjectsV2Request> marshall(ListObjectsV2Request listObjectsV2Request) {

        if (listObjectsV2Request == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<ListObjectsV2Request> request = new DefaultRequest<ListObjectsV2Request>(listObjectsV2Request, "S3Client");

        request.setHttpMethod(HttpMethodName.GET);

        if (listObjectsV2Request.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(listObjectsV2Request.requestPayerString()));
        }

        String uriResourcePath = "/{Bucket}?list-type=2";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", listObjectsV2Request.bucket());
        request.setResourcePath(uriResourcePath);

        if (listObjectsV2Request.delimiter() != null) {
            request.addParameter("delimiter", StringUtils.fromString(listObjectsV2Request.delimiter()));
        }

        if (listObjectsV2Request.encodingTypeString() != null) {
            request.addParameter("encoding-type", StringUtils.fromString(listObjectsV2Request.encodingTypeString()));
        }

        if (listObjectsV2Request.maxKeys() != null) {
            request.addParameter("max-keys", StringUtils.fromInteger(listObjectsV2Request.maxKeys()));
        }

        if (listObjectsV2Request.prefix() != null) {
            request.addParameter("prefix", StringUtils.fromString(listObjectsV2Request.prefix()));
        }

        if (listObjectsV2Request.continuationToken() != null) {
            request.addParameter("continuation-token", StringUtils.fromString(listObjectsV2Request.continuationToken()));
        }

        if (listObjectsV2Request.fetchOwner() != null) {
            request.addParameter("fetch-owner", StringUtils.fromBoolean(listObjectsV2Request.fetchOwner()));
        }

        if (listObjectsV2Request.startAfter() != null) {
            request.addParameter("start-after", StringUtils.fromString(listObjectsV2Request.startAfter()));
        }

        return request;
    }

}