/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * ListObjectsV2Response StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class ListObjectsV2ResponseUnmarshaller implements Unmarshaller<ListObjectsV2Response, StaxUnmarshallerContext> {

    public ListObjectsV2Response unmarshall(StaxUnmarshallerContext context) throws Exception {
        ListObjectsV2Response.Builder listObjectsV2Response = ListObjectsV2Response.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        java.util.List<S3Object> contents = null;
        java.util.List<CommonPrefix> commonPrefixes = null;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                listObjectsV2Response.contents(contents);
                listObjectsV2Response.commonPrefixes(commonPrefixes);
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("IsTruncated", targetDepth)) {
                    listObjectsV2Response.isTruncated(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Contents", targetDepth)) {
                    if (contents == null) {
                        contents = new ArrayList<>();
                    }
                    contents.add(S3ObjectUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Name", targetDepth)) {
                    listObjectsV2Response.name(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Prefix", targetDepth)) {
                    listObjectsV2Response.prefix(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("Delimiter", targetDepth)) {
                    listObjectsV2Response.delimiter(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("MaxKeys", targetDepth)) {
                    listObjectsV2Response.maxKeys(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("CommonPrefixes", targetDepth)) {
                    if (commonPrefixes == null) {
                        commonPrefixes = new ArrayList<>();
                    }
                    commonPrefixes.add(CommonPrefixUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("EncodingType", targetDepth)) {
                    listObjectsV2Response.encodingType(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("KeyCount", targetDepth)) {
                    listObjectsV2Response.keyCount(IntegerUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ContinuationToken", targetDepth)) {
                    listObjectsV2Response.continuationToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("NextContinuationToken", targetDepth)) {
                    listObjectsV2Response.nextContinuationToken(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("StartAfter", targetDepth)) {
                    listObjectsV2Response.startAfter(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    listObjectsV2Response.contents(contents);
                    listObjectsV2Response.commonPrefixes(commonPrefixes);
                    break;
                }
            }
        }
        return listObjectsV2Response.build();
    }

    private static final ListObjectsV2ResponseUnmarshaller INSTANCE = new ListObjectsV2ResponseUnmarshaller();

    public static ListObjectsV2ResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
