/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import static software.amazon.awssdk.core.util.StringUtils.UTF8;

import java.io.StringWriter;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringInputStream;
import software.amazon.awssdk.core.util.StringUtils;

import software.amazon.awssdk.core.util.Md5Utils;
import software.amazon.awssdk.core.util.XmlWriter;

/**
 * PutObjectAclRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class PutObjectAclRequestMarshaller implements Marshaller<Request<PutObjectAclRequest>, PutObjectAclRequest> {

    public Request<PutObjectAclRequest> marshall(PutObjectAclRequest putObjectAclRequest) {

        if (putObjectAclRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<PutObjectAclRequest> request = new DefaultRequest<PutObjectAclRequest>(putObjectAclRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (putObjectAclRequest.aclString() != null) {
            request.addHeader("x-amz-acl", StringUtils.fromString(putObjectAclRequest.aclString()));
        }

        if (putObjectAclRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(putObjectAclRequest.contentMD5()));
        }

        if (putObjectAclRequest.grantFullControl() != null) {
            request.addHeader("x-amz-grant-full-control", StringUtils.fromString(putObjectAclRequest.grantFullControl()));
        }

        if (putObjectAclRequest.grantRead() != null) {
            request.addHeader("x-amz-grant-read", StringUtils.fromString(putObjectAclRequest.grantRead()));
        }

        if (putObjectAclRequest.grantReadACP() != null) {
            request.addHeader("x-amz-grant-read-acp", StringUtils.fromString(putObjectAclRequest.grantReadACP()));
        }

        if (putObjectAclRequest.grantWrite() != null) {
            request.addHeader("x-amz-grant-write", StringUtils.fromString(putObjectAclRequest.grantWrite()));
        }

        if (putObjectAclRequest.grantWriteACP() != null) {
            request.addHeader("x-amz-grant-write-acp", StringUtils.fromString(putObjectAclRequest.grantWriteACP()));
        }

        if (putObjectAclRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(putObjectAclRequest.requestPayerString()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}?acl";

        uriResourcePath = software.amazon.awssdk.core.util.UriResourcePathUtils.addStaticQueryParametersToRequest(request,
                uriResourcePath);

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", putObjectAclRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                putObjectAclRequest.key());
        request.setResourcePath(uriResourcePath);

        if (putObjectAclRequest.versionId() != null) {
            request.addParameter("versionId", StringUtils.fromString(putObjectAclRequest.versionId()));
        }

        try {
            StringWriter stringWriter = null;
            AccessControlPolicy accessControlPolicy = putObjectAclRequest.accessControlPolicy();
            if (accessControlPolicy != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter(stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("AccessControlPolicy");

                java.util.List<Grant> accessControlPolicyGrantsList = accessControlPolicy.grants();
                if (accessControlPolicyGrantsList != null) {
                    xmlWriter.startElement("AccessControlList");

                    for (Grant accessControlPolicyGrantsListValue : accessControlPolicyGrantsList) {
                        xmlWriter.startElement("Grant");

                        Grantee grantee = accessControlPolicyGrantsListValue.grantee();
                        if (grantee != null) {
                            xmlWriter.startElement("Grantee");

                            if (grantee.displayName() != null) {
                                xmlWriter.startElement("DisplayName").value(grantee.displayName()).endElement();
                            }

                            if (grantee.emailAddress() != null) {
                                xmlWriter.startElement("EmailAddress").value(grantee.emailAddress()).endElement();
                            }

                            if (grantee.id() != null) {
                                xmlWriter.startElement("ID").value(grantee.id()).endElement();
                            }

                            if (grantee.typeString() != null) {
                                xmlWriter.startElement("xsi:type").value(grantee.typeString()).endElement();
                            }

                            if (grantee.uri() != null) {
                                xmlWriter.startElement("URI").value(grantee.uri()).endElement();
                            }
                            xmlWriter.endElement();
                        }

                        if (accessControlPolicyGrantsListValue.permissionString() != null) {
                            xmlWriter.startElement("Permission").value(accessControlPolicyGrantsListValue.permissionString())
                                    .endElement();
                        }
                        xmlWriter.endElement();
                    }
                    xmlWriter.endElement();
                }

                Owner owner = accessControlPolicy.owner();
                if (owner != null) {
                    xmlWriter.startElement("Owner");

                    if (owner.displayName() != null) {
                        xmlWriter.startElement("DisplayName").value(owner.displayName()).endElement();
                    }

                    if (owner.id() != null) {
                        xmlWriter.startElement("ID").value(owner.id()).endElement();
                    }
                    xmlWriter.endElement();
                }
                xmlWriter.endElement();
            }

            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64(stringWriter.getBuffer().toString().getBytes(UTF8)));
                }
                request.setContent(new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(UTF8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        } catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to XML: " + t.getMessage(), t);
        }

        return request;
    }

}