/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.s3.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;

import software.amazon.awssdk.core.util.StringUtils;

/**
 * UploadPartRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UploadPartRequestMarshaller implements Marshaller<Request<UploadPartRequest>, UploadPartRequest> {

    public Request<UploadPartRequest> marshall(UploadPartRequest uploadPartRequest) {

        if (uploadPartRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<UploadPartRequest> request = new DefaultRequest<UploadPartRequest>(uploadPartRequest, "S3Client");

        request.setHttpMethod(HttpMethodName.PUT);

        if (uploadPartRequest.contentLength() != null) {
            request.addHeader("Content-Length", StringUtils.fromLong(uploadPartRequest.contentLength()));
        }

        if (uploadPartRequest.contentMD5() != null) {
            request.addHeader("Content-MD5", StringUtils.fromString(uploadPartRequest.contentMD5()));
        }

        if (uploadPartRequest.sseCustomerAlgorithm() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-algorithm",
                    StringUtils.fromString(uploadPartRequest.sseCustomerAlgorithm()));
        }

        if (uploadPartRequest.sseCustomerKey() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key",
                    StringUtils.fromString(uploadPartRequest.sseCustomerKey()));
        }

        if (uploadPartRequest.sseCustomerKeyMD5() != null) {
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5",
                    StringUtils.fromString(uploadPartRequest.sseCustomerKeyMD5()));
        }

        if (uploadPartRequest.requestPayerString() != null) {
            request.addHeader("x-amz-request-payer", StringUtils.fromString(uploadPartRequest.requestPayerString()));
        }

        String uriResourcePath = "/{Bucket}/{Key+}";

        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.NON_GREEDY.marshall(uriResourcePath,
                "Bucket", uploadPartRequest.bucket());
        uriResourcePath = software.amazon.awssdk.core.runtime.transform.PathMarshallers.GREEDY.marshall(uriResourcePath, "Key",
                uploadPartRequest.key());
        request.setResourcePath(uriResourcePath);

        if (uploadPartRequest.partNumber() != null) {
            request.addParameter("partNumber", StringUtils.fromInteger(uploadPartRequest.partNumber()));
        }

        if (uploadPartRequest.uploadId() != null) {
            request.addParameter("uploadId", StringUtils.fromString(uploadPartRequest.uploadId()));
        }

        return request;
    }

}