/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.s3.model.ErrorDocument;
import software.amazon.awssdk.services.s3.model.IndexDocument;
import software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo;
import software.amazon.awssdk.services.s3.model.RoutingRule;
import software.amazon.awssdk.services.s3.model.RoutingRulesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class WebsiteConfiguration
implements ToCopyableBuilder<Builder, WebsiteConfiguration> {
    private final ErrorDocument errorDocument;
    private final IndexDocument indexDocument;
    private final RedirectAllRequestsTo redirectAllRequestsTo;
    private final List<RoutingRule> routingRules;

    private WebsiteConfiguration(BuilderImpl builder) {
        this.errorDocument = builder.errorDocument;
        this.indexDocument = builder.indexDocument;
        this.redirectAllRequestsTo = builder.redirectAllRequestsTo;
        this.routingRules = builder.routingRules;
    }

    public ErrorDocument errorDocument() {
        return this.errorDocument;
    }

    public IndexDocument indexDocument() {
        return this.indexDocument;
    }

    public RedirectAllRequestsTo redirectAllRequestsTo() {
        return this.redirectAllRequestsTo;
    }

    public List<RoutingRule> routingRules() {
        return this.routingRules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectAllRequestsTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebsiteConfiguration)) {
            return false;
        }
        WebsiteConfiguration other = (WebsiteConfiguration)obj;
        return Objects.equals(this.errorDocument(), other.errorDocument()) && Objects.equals(this.indexDocument(), other.indexDocument()) && Objects.equals(this.redirectAllRequestsTo(), other.redirectAllRequestsTo()) && Objects.equals(this.routingRules(), other.routingRules());
    }

    public String toString() {
        return ToString.builder((String)"WebsiteConfiguration").add("ErrorDocument", (Object)this.errorDocument()).add("IndexDocument", (Object)this.indexDocument()).add("RedirectAllRequestsTo", (Object)this.redirectAllRequestsTo()).add("RoutingRules", this.routingRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ErrorDocument": {
                return Optional.of(clazz.cast(this.errorDocument()));
            }
            case "IndexDocument": {
                return Optional.of(clazz.cast(this.indexDocument()));
            }
            case "RedirectAllRequestsTo": {
                return Optional.of(clazz.cast(this.redirectAllRequestsTo()));
            }
            case "RoutingRules": {
                return Optional.of(clazz.cast(this.routingRules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private ErrorDocument errorDocument;
        private IndexDocument indexDocument;
        private RedirectAllRequestsTo redirectAllRequestsTo;
        private List<RoutingRule> routingRules;

        private BuilderImpl() {
        }

        private BuilderImpl(WebsiteConfiguration model) {
            this.errorDocument(model.errorDocument);
            this.indexDocument(model.indexDocument);
            this.redirectAllRequestsTo(model.redirectAllRequestsTo);
            this.routingRules(model.routingRules);
        }

        public final ErrorDocument.Builder getErrorDocument() {
            return this.errorDocument != null ? this.errorDocument.toBuilder() : null;
        }

        @Override
        public final Builder errorDocument(ErrorDocument errorDocument) {
            this.errorDocument = errorDocument;
            return this;
        }

        public final void setErrorDocument(ErrorDocument.BuilderImpl errorDocument) {
            this.errorDocument = errorDocument != null ? errorDocument.build() : null;
        }

        public final IndexDocument.Builder getIndexDocument() {
            return this.indexDocument != null ? this.indexDocument.toBuilder() : null;
        }

        @Override
        public final Builder indexDocument(IndexDocument indexDocument) {
            this.indexDocument = indexDocument;
            return this;
        }

        public final void setIndexDocument(IndexDocument.BuilderImpl indexDocument) {
            this.indexDocument = indexDocument != null ? indexDocument.build() : null;
        }

        public final RedirectAllRequestsTo.Builder getRedirectAllRequestsTo() {
            return this.redirectAllRequestsTo != null ? this.redirectAllRequestsTo.toBuilder() : null;
        }

        @Override
        public final Builder redirectAllRequestsTo(RedirectAllRequestsTo redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo;
            return this;
        }

        public final void setRedirectAllRequestsTo(RedirectAllRequestsTo.BuilderImpl redirectAllRequestsTo) {
            this.redirectAllRequestsTo = redirectAllRequestsTo != null ? redirectAllRequestsTo.build() : null;
        }

        public final Collection<RoutingRule.Builder> getRoutingRules() {
            return this.routingRules != null ? (Collection)this.routingRules.stream().map(RoutingRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder routingRules(Collection<RoutingRule> routingRules) {
            this.routingRules = RoutingRulesCopier.copy(routingRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingRules(RoutingRule ... routingRules) {
            this.routingRules(Arrays.asList(routingRules));
            return this;
        }

        public final void setRoutingRules(Collection<RoutingRule.BuilderImpl> routingRules) {
            this.routingRules = RoutingRulesCopier.copyFromBuilder(routingRules);
        }

        public WebsiteConfiguration build() {
            return new WebsiteConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, WebsiteConfiguration> {
        public Builder errorDocument(ErrorDocument var1);

        default public Builder errorDocument(Consumer<ErrorDocument.Builder> errorDocument) {
            return this.errorDocument((ErrorDocument)((ErrorDocument.Builder)ErrorDocument.builder().apply(errorDocument)).build());
        }

        public Builder indexDocument(IndexDocument var1);

        default public Builder indexDocument(Consumer<IndexDocument.Builder> indexDocument) {
            return this.indexDocument((IndexDocument)((IndexDocument.Builder)IndexDocument.builder().apply(indexDocument)).build());
        }

        public Builder redirectAllRequestsTo(RedirectAllRequestsTo var1);

        default public Builder redirectAllRequestsTo(Consumer<RedirectAllRequestsTo.Builder> redirectAllRequestsTo) {
            return this.redirectAllRequestsTo((RedirectAllRequestsTo)((RedirectAllRequestsTo.Builder)RedirectAllRequestsTo.builder().apply(redirectAllRequestsTo)).build());
        }

        public Builder routingRules(Collection<RoutingRule> var1);

        public Builder routingRules(RoutingRule ... var1);
    }
}

