/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.handlers;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.ClientType;
import software.amazon.awssdk.core.checksums.Md5Checksum;
import software.amazon.awssdk.core.checksums.SdkChecksum;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttribute;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.checksums.ChecksumCalculatingInputStream;
import software.amazon.awssdk.services.s3.checksums.ChecksumValidatingInputStream;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.internal.Base16Lower;

@SdkInternalApi
public class SyncChecksumValidationInterceptor
implements ExecutionInterceptor {
    private static final ExecutionAttribute<SdkChecksum> CHECKSUM = new ExecutionAttribute("checksum");

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof GetObjectRequest && this.checksumValidationEnabled(executionAttributes)) {
            return (SdkHttpRequest)((SdkHttpRequest.Builder)context.httpRequest().toBuilder()).putHeader("x-amz-te", "append-md5").build();
        }
        return context.httpRequest();
    }

    public Optional<RequestBody> modifyHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        boolean checksumValidationEnabled = this.checksumValidationEnabled(executionAttributes);
        if (context.request() instanceof PutObjectRequest && checksumValidationEnabled) {
            Md5Checksum checksum = new Md5Checksum();
            ChecksumCalculatingInputStream is = new ChecksumCalculatingInputStream(((RequestBody)context.requestBody().get()).contentStreamProvider().newStream(), (SdkChecksum)checksum);
            executionAttributes.putAttribute(CHECKSUM, (Object)checksum);
            return Optional.of(RequestBody.fromContentProvider(() -> is, (long)((RequestBody)context.requestBody().get()).contentLength(), (String)((RequestBody)context.requestBody().get()).contentType()));
        }
        return context.requestBody();
    }

    public Optional<InputStream> modifyHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof GetObjectRequest && this.checksumValidationEnabled(executionAttributes)) {
            SdkHttpResponse originalResponse = context.httpResponse();
            Md5Checksum checksum = new Md5Checksum();
            int contentLength = Integer.valueOf(context.httpResponse().firstMatchingHeader("Content-Length").orElse("0"));
            if (contentLength > 0) {
                return Optional.of(new ChecksumValidatingInputStream((InputStream)context.responseBody().get(), (SdkChecksum)checksum, contentLength));
            }
        }
        return context.responseBody();
    }

    public void afterUnmarshalling(Context.AfterUnmarshalling context, ExecutionAttributes executionAttributes) {
        byte[] ssHash;
        SdkChecksum checksum;
        String contentMd5;
        byte[] digest;
        PutObjectResponse response;
        if (context.response() instanceof PutObjectResponse && this.checksumValidationEnabled(executionAttributes) && (response = (PutObjectResponse)context.response()).eTag() != null && !Arrays.equals(digest = BinaryUtils.fromBase64((String)(contentMd5 = BinaryUtils.toBase64((byte[])(checksum = (SdkChecksum)executionAttributes.getAttribute(CHECKSUM)).getChecksumBytes()))), ssHash = Base16Lower.decode((String)response.eTag().replace("\"", "")))) {
            throw SdkClientException.create((String)String.format("Data read has a different checksum than expected. Was %d, but expected %d", digest, ssHash));
        }
    }

    private boolean checksumValidationEnabled(ExecutionAttributes executionAttributes) {
        ClientType clientType = (ClientType)executionAttributes.getAttribute(SdkExecutionAttribute.CLIENT_TYPE);
        if (ClientType.SYNC.equals((Object)clientType)) {
            S3Configuration serviceConfiguration = (S3Configuration)executionAttributes.getAttribute(AwsSignerExecutionAttribute.SERVICE_CONFIG);
            return serviceConfiguration == null || serviceConfiguration.checksumValidationEnabled();
        }
        return false;
    }
}

