/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBucketAccelerateConfigurationRequest extends S3Request implements
        ToCopyableBuilder<PutBucketAccelerateConfigurationRequest.Builder, PutBucketAccelerateConfigurationRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutBucketAccelerateConfigurationRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<AccelerateConfiguration> ACCELERATE_CONFIGURATION_FIELD = SdkField
            .<AccelerateConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutBucketAccelerateConfigurationRequest::accelerateConfiguration))
            .setter(setter(Builder::accelerateConfiguration))
            .constructor(AccelerateConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccelerateConfiguration")
                    .unmarshallLocationName("AccelerateConfiguration").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            ACCELERATE_CONFIGURATION_FIELD));

    private final String bucket;

    private final AccelerateConfiguration accelerateConfiguration;

    private PutBucketAccelerateConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.accelerateConfiguration = builder.accelerateConfiguration;
    }

    /**
     * <p>
     * Name of the bucket for which the accelerate configuration is set.
     * </p>
     * 
     * @return Name of the bucket for which the accelerate configuration is set.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * Specifies the Accelerate Configuration you want to set for the bucket.
     * </p>
     * 
     * @return Specifies the Accelerate Configuration you want to set for the bucket.
     */
    public AccelerateConfiguration accelerateConfiguration() {
        return accelerateConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(accelerateConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketAccelerateConfigurationRequest)) {
            return false;
        }
        PutBucketAccelerateConfigurationRequest other = (PutBucketAccelerateConfigurationRequest) obj;
        return Objects.equals(bucket(), other.bucket())
                && Objects.equals(accelerateConfiguration(), other.accelerateConfiguration());
    }

    @Override
    public String toString() {
        return ToString.builder("PutBucketAccelerateConfigurationRequest").add("Bucket", bucket())
                .add("AccelerateConfiguration", accelerateConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "AccelerateConfiguration":
            return Optional.ofNullable(clazz.cast(accelerateConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBucketAccelerateConfigurationRequest, T> g) {
        return obj -> g.apply((PutBucketAccelerateConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Request.Builder, SdkPojo,
            CopyableBuilder<Builder, PutBucketAccelerateConfigurationRequest> {
        /**
         * <p>
         * Name of the bucket for which the accelerate configuration is set.
         * </p>
         * 
         * @param bucket
         *        Name of the bucket for which the accelerate configuration is set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * Specifies the Accelerate Configuration you want to set for the bucket.
         * </p>
         * 
         * @param accelerateConfiguration
         *        Specifies the Accelerate Configuration you want to set for the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accelerateConfiguration(AccelerateConfiguration accelerateConfiguration);

        /**
         * <p>
         * Specifies the Accelerate Configuration you want to set for the bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link AccelerateConfiguration.Builder} avoiding the
         * need to create one manually via {@link AccelerateConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccelerateConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #accelerateConfiguration(AccelerateConfiguration)}.
         * 
         * @param accelerateConfiguration
         *        a consumer that will call methods on {@link AccelerateConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accelerateConfiguration(AccelerateConfiguration)
         */
        default Builder accelerateConfiguration(Consumer<AccelerateConfiguration.Builder> accelerateConfiguration) {
            return accelerateConfiguration(AccelerateConfiguration.builder().applyMutation(accelerateConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private AccelerateConfiguration accelerateConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketAccelerateConfigurationRequest model) {
            super(model);
            bucket(model.bucket);
            accelerateConfiguration(model.accelerateConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final AccelerateConfiguration.Builder getAccelerateConfiguration() {
            return accelerateConfiguration != null ? accelerateConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder accelerateConfiguration(AccelerateConfiguration accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration;
            return this;
        }

        public final void setAccelerateConfiguration(AccelerateConfiguration.BuilderImpl accelerateConfiguration) {
            this.accelerateConfiguration = accelerateConfiguration != null ? accelerateConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketAccelerateConfigurationRequest build() {
            return new PutBucketAccelerateConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
