/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBucketCorsRequest extends S3Request implements
        ToCopyableBuilder<PutBucketCorsRequest.Builder, PutBucketCorsRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutBucketCorsRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<CORSConfiguration> CORS_CONFIGURATION_FIELD = SdkField
            .<CORSConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutBucketCorsRequest::corsConfiguration))
            .setter(setter(Builder::corsConfiguration))
            .constructor(CORSConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CORSConfiguration")
                    .unmarshallLocationName("CORSConfiguration").build(), PayloadTrait.create()).build();

    private static final SdkField<String> CONTENT_MD5_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutBucketCorsRequest::contentMD5))
            .setter(setter(Builder::contentMD5))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-MD5")
                    .unmarshallLocationName("Content-MD5").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            CORS_CONFIGURATION_FIELD, CONTENT_MD5_FIELD));

    private final String bucket;

    private final CORSConfiguration corsConfiguration;

    private final String contentMD5;

    private PutBucketCorsRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.corsConfiguration = builder.corsConfiguration;
        this.contentMD5 = builder.contentMD5;
    }

    /**
     * <p>
     * Specifies the bucket impacted by the <code>cors</code>configuration.
     * </p>
     * 
     * @return Specifies the bucket impacted by the <code>cors</code>configuration.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/dev//cors.html">Enabling Cross-Origin Resource Sharing</a> in
     * the Amazon Simple Storage Service Developer Guide.
     * </p>
     * 
     * @return Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information,
     *         see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev//cors.html">Enabling Cross-Origin Resource
     *         Sharing</a> in the Amazon Simple Storage Service Developer Guide.
     */
    public CORSConfiguration corsConfiguration() {
        return corsConfiguration;
    }

    /**
     * <p>
     * The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to
     * verify that the request body was not corrupted in transit. For more information, go to <a
     * href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a>
     * </p>
     * 
     * @return The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check
     *         to verify that the request body was not corrupted in transit. For more information, go to <a
     *         href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a>
     */
    public String contentMD5() {
        return contentMD5;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(corsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketCorsRequest)) {
            return false;
        }
        PutBucketCorsRequest other = (PutBucketCorsRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(corsConfiguration(), other.corsConfiguration())
                && Objects.equals(contentMD5(), other.contentMD5());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutBucketCorsRequest").add("Bucket", bucket()).add("CORSConfiguration", corsConfiguration())
                .add("ContentMD5", contentMD5()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "CORSConfiguration":
            return Optional.ofNullable(clazz.cast(corsConfiguration()));
        case "ContentMD5":
            return Optional.ofNullable(clazz.cast(contentMD5()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBucketCorsRequest, T> g) {
        return obj -> g.apply((PutBucketCorsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Request.Builder, SdkPojo, CopyableBuilder<Builder, PutBucketCorsRequest> {
        /**
         * <p>
         * Specifies the bucket impacted by the <code>cors</code>configuration.
         * </p>
         * 
         * @param bucket
         *        Specifies the bucket impacted by the <code>cors</code>configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev//cors.html">Enabling Cross-Origin Resource
         * Sharing</a> in the Amazon Simple Storage Service Developer Guide.
         * </p>
         * 
         * @param corsConfiguration
         *        Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more
         *        information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev//cors.html">Enabling
         *        Cross-Origin Resource Sharing</a> in the Amazon Simple Storage Service Developer Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsConfiguration(CORSConfiguration corsConfiguration);

        /**
         * <p>
         * Describes the cross-origin access configuration for objects in an Amazon S3 bucket. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev//cors.html">Enabling Cross-Origin Resource
         * Sharing</a> in the Amazon Simple Storage Service Developer Guide.
         * </p>
         * This is a convenience that creates an instance of the {@link CORSConfiguration.Builder} avoiding the need to
         * create one manually via {@link CORSConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CORSConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #corsConfiguration(CORSConfiguration)}.
         * 
         * @param corsConfiguration
         *        a consumer that will call methods on {@link CORSConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #corsConfiguration(CORSConfiguration)
         */
        default Builder corsConfiguration(Consumer<CORSConfiguration.Builder> corsConfiguration) {
            return corsConfiguration(CORSConfiguration.builder().applyMutation(corsConfiguration).build());
        }

        /**
         * <p>
         * The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity check to
         * verify that the request body was not corrupted in transit. For more information, go to <a
         * href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a>
         * </p>
         * 
         * @param contentMD5
         *        The base64-encoded 128-bit MD5 digest of the data. This header must be used as a message integrity
         *        check to verify that the request body was not corrupted in transit. For more information, go to <a
         *        href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private CORSConfiguration corsConfiguration;

        private String contentMD5;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketCorsRequest model) {
            super(model);
            bucket(model.bucket);
            corsConfiguration(model.corsConfiguration);
            contentMD5(model.contentMD5);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final CORSConfiguration.Builder getCorsConfiguration() {
            return corsConfiguration != null ? corsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder corsConfiguration(CORSConfiguration corsConfiguration) {
            this.corsConfiguration = corsConfiguration;
            return this;
        }

        public final void setCorsConfiguration(CORSConfiguration.BuilderImpl corsConfiguration) {
            this.corsConfiguration = corsConfiguration != null ? corsConfiguration.build() : null;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketCorsRequest build() {
            return new PutBucketCorsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
