/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBucketRequestPaymentRequest extends S3Request implements
        ToCopyableBuilder<PutBucketRequestPaymentRequest.Builder, PutBucketRequestPaymentRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutBucketRequestPaymentRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> CONTENT_MD5_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutBucketRequestPaymentRequest::contentMD5))
            .setter(setter(Builder::contentMD5))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-MD5")
                    .unmarshallLocationName("Content-MD5").build()).build();

    private static final SdkField<RequestPaymentConfiguration> REQUEST_PAYMENT_CONFIGURATION_FIELD = SdkField
            .<RequestPaymentConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutBucketRequestPaymentRequest::requestPaymentConfiguration))
            .setter(setter(Builder::requestPaymentConfiguration))
            .constructor(RequestPaymentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestPaymentConfiguration")
                    .unmarshallLocationName("RequestPaymentConfiguration").build(), PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            CONTENT_MD5_FIELD, REQUEST_PAYMENT_CONFIGURATION_FIELD));

    private final String bucket;

    private final String contentMD5;

    private final RequestPaymentConfiguration requestPaymentConfiguration;

    private PutBucketRequestPaymentRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.requestPaymentConfiguration = builder.requestPaymentConfiguration;
    }

    /**
     * <p>
     * The bucket name.
     * </p>
     * 
     * @return The bucket name.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * &gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check to
     * verify that the request body was not corrupted in transit. For more information, see <a
     * href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.
     * </p>
     * 
     * @return &gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity
     *         check to verify that the request body was not corrupted in transit. For more information, see <a
     *         href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * <p>
     * Container for Payer.
     * </p>
     * 
     * @return Container for Payer.
     */
    public RequestPaymentConfiguration requestPaymentConfiguration() {
        return requestPaymentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(requestPaymentConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketRequestPaymentRequest)) {
            return false;
        }
        PutBucketRequestPaymentRequest other = (PutBucketRequestPaymentRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(contentMD5(), other.contentMD5())
                && Objects.equals(requestPaymentConfiguration(), other.requestPaymentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutBucketRequestPaymentRequest").add("Bucket", bucket()).add("ContentMD5", contentMD5())
                .add("RequestPaymentConfiguration", requestPaymentConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "ContentMD5":
            return Optional.ofNullable(clazz.cast(contentMD5()));
        case "RequestPaymentConfiguration":
            return Optional.ofNullable(clazz.cast(requestPaymentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBucketRequestPaymentRequest, T> g) {
        return obj -> g.apply((PutBucketRequestPaymentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Request.Builder, SdkPojo, CopyableBuilder<Builder, PutBucketRequestPaymentRequest> {
        /**
         * <p>
         * The bucket name.
         * </p>
         * 
         * @param bucket
         *        The bucket name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * &gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity check
         * to verify that the request body was not corrupted in transit. For more information, see <a
         * href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.
         * </p>
         * 
         * @param contentMD5
         *        &gt;The base64-encoded 128-bit MD5 digest of the data. You must use this header as a message integrity
         *        check to verify that the request body was not corrupted in transit. For more information, see <a
         *        href="http://www.ietf.org/rfc/rfc1864.txt">RFC 1864</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * <p>
         * Container for Payer.
         * </p>
         * 
         * @param requestPaymentConfiguration
         *        Container for Payer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestPaymentConfiguration(RequestPaymentConfiguration requestPaymentConfiguration);

        /**
         * <p>
         * Container for Payer.
         * </p>
         * This is a convenience that creates an instance of the {@link RequestPaymentConfiguration.Builder} avoiding
         * the need to create one manually via {@link RequestPaymentConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RequestPaymentConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #requestPaymentConfiguration(RequestPaymentConfiguration)}.
         * 
         * @param requestPaymentConfiguration
         *        a consumer that will call methods on {@link RequestPaymentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestPaymentConfiguration(RequestPaymentConfiguration)
         */
        default Builder requestPaymentConfiguration(Consumer<RequestPaymentConfiguration.Builder> requestPaymentConfiguration) {
            return requestPaymentConfiguration(RequestPaymentConfiguration.builder().applyMutation(requestPaymentConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String contentMD5;

        private RequestPaymentConfiguration requestPaymentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketRequestPaymentRequest model) {
            super(model);
            bucket(model.bucket);
            contentMD5(model.contentMD5);
            requestPaymentConfiguration(model.requestPaymentConfiguration);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final RequestPaymentConfiguration.Builder getRequestPaymentConfiguration() {
            return requestPaymentConfiguration != null ? requestPaymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder requestPaymentConfiguration(RequestPaymentConfiguration requestPaymentConfiguration) {
            this.requestPaymentConfiguration = requestPaymentConfiguration;
            return this;
        }

        public final void setRequestPaymentConfiguration(RequestPaymentConfiguration.BuilderImpl requestPaymentConfiguration) {
            this.requestPaymentConfiguration = requestPaymentConfiguration != null ? requestPaymentConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketRequestPaymentRequest build() {
            return new PutBucketRequestPaymentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
