/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutBucketLifecycleConfigurationRequest extends S3Request implements
        ToCopyableBuilder<PutBucketLifecycleConfigurationRequest.Builder, PutBucketLifecycleConfigurationRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutBucketLifecycleConfigurationRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<BucketLifecycleConfiguration> LIFECYCLE_CONFIGURATION_FIELD = SdkField
            .<BucketLifecycleConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutBucketLifecycleConfigurationRequest::lifecycleConfiguration))
            .setter(setter(Builder::lifecycleConfiguration))
            .constructor(BucketLifecycleConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleConfiguration")
                    .unmarshallLocationName("LifecycleConfiguration").build(), PayloadTrait.create()).build();

    private static final SdkField<String> EXPECTED_BUCKET_OWNER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutBucketLifecycleConfigurationRequest::expectedBucketOwner))
            .setter(setter(Builder::expectedBucketOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-expected-bucket-owner")
                    .unmarshallLocationName("x-amz-expected-bucket-owner").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD,
            LIFECYCLE_CONFIGURATION_FIELD, EXPECTED_BUCKET_OWNER_FIELD));

    private final String bucket;

    private final BucketLifecycleConfiguration lifecycleConfiguration;

    private final String expectedBucketOwner;

    private PutBucketLifecycleConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
        this.expectedBucketOwner = builder.expectedBucketOwner;
    }

    /**
     * <p>
     * The name of the bucket for which to set the configuration.
     * </p>
     * 
     * @return The name of the bucket for which to set the configuration.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * Container for lifecycle rules. You can add as many as 1,000 rules.
     * </p>
     * 
     * @return Container for lifecycle rules. You can add as many as 1,000 rules.
     */
    public BucketLifecycleConfiguration lifecycleConfiguration() {
        return lifecycleConfiguration;
    }

    /**
     * <p>
     * The account id of the expected bucket owner. If the bucket is owned by a different account, the request will fail
     * with an HTTP <code>403 (Access Denied)</code> error.
     * </p>
     * 
     * @return The account id of the expected bucket owner. If the bucket is owned by a different account, the request
     *         will fail with an HTTP <code>403 (Access Denied)</code> error.
     */
    public String expectedBucketOwner() {
        return expectedBucketOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(expectedBucketOwner());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketLifecycleConfigurationRequest)) {
            return false;
        }
        PutBucketLifecycleConfigurationRequest other = (PutBucketLifecycleConfigurationRequest) obj;
        return Objects.equals(bucket(), other.bucket())
                && Objects.equals(lifecycleConfiguration(), other.lifecycleConfiguration())
                && Objects.equals(expectedBucketOwner(), other.expectedBucketOwner());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutBucketLifecycleConfigurationRequest").add("Bucket", bucket())
                .add("LifecycleConfiguration", lifecycleConfiguration()).add("ExpectedBucketOwner", expectedBucketOwner())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "LifecycleConfiguration":
            return Optional.ofNullable(clazz.cast(lifecycleConfiguration()));
        case "ExpectedBucketOwner":
            return Optional.ofNullable(clazz.cast(expectedBucketOwner()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBucketLifecycleConfigurationRequest, T> g) {
        return obj -> g.apply((PutBucketLifecycleConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Request.Builder, SdkPojo, CopyableBuilder<Builder, PutBucketLifecycleConfigurationRequest> {
        /**
         * <p>
         * The name of the bucket for which to set the configuration.
         * </p>
         * 
         * @param bucket
         *        The name of the bucket for which to set the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * Container for lifecycle rules. You can add as many as 1,000 rules.
         * </p>
         * 
         * @param lifecycleConfiguration
         *        Container for lifecycle rules. You can add as many as 1,000 rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleConfiguration(BucketLifecycleConfiguration lifecycleConfiguration);

        /**
         * <p>
         * Container for lifecycle rules. You can add as many as 1,000 rules.
         * </p>
         * This is a convenience that creates an instance of the {@link BucketLifecycleConfiguration.Builder} avoiding
         * the need to create one manually via {@link BucketLifecycleConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketLifecycleConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycleConfiguration(BucketLifecycleConfiguration)}.
         * 
         * @param lifecycleConfiguration
         *        a consumer that will call methods on {@link BucketLifecycleConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleConfiguration(BucketLifecycleConfiguration)
         */
        default Builder lifecycleConfiguration(Consumer<BucketLifecycleConfiguration.Builder> lifecycleConfiguration) {
            return lifecycleConfiguration(BucketLifecycleConfiguration.builder().applyMutation(lifecycleConfiguration).build());
        }

        /**
         * <p>
         * The account id of the expected bucket owner. If the bucket is owned by a different account, the request will
         * fail with an HTTP <code>403 (Access Denied)</code> error.
         * </p>
         * 
         * @param expectedBucketOwner
         *        The account id of the expected bucket owner. If the bucket is owned by a different account, the
         *        request will fail with an HTTP <code>403 (Access Denied)</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedBucketOwner(String expectedBucketOwner);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private BucketLifecycleConfiguration lifecycleConfiguration;

        private String expectedBucketOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketLifecycleConfigurationRequest model) {
            super(model);
            bucket(model.bucket);
            lifecycleConfiguration(model.lifecycleConfiguration);
            expectedBucketOwner(model.expectedBucketOwner);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final BucketLifecycleConfiguration.Builder getLifecycleConfiguration() {
            return lifecycleConfiguration != null ? lifecycleConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(BucketLifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final void setLifecycleConfiguration(BucketLifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        public final String getExpectedBucketOwner() {
            return expectedBucketOwner;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        public final void setExpectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketLifecycleConfigurationRequest build() {
            return new PutBucketLifecycleConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
