/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container element for a bucket's ownership controls.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OwnershipControls implements SdkPojo, Serializable,
        ToCopyableBuilder<OwnershipControls.Builder, OwnershipControls> {
    private static final SdkField<List<OwnershipControlsRule>> RULES_FIELD = SdkField
            .<List<OwnershipControlsRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(OwnershipControls::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule")
                    .unmarshallLocationName("Rule").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OwnershipControlsRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(OwnershipControlsRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<OwnershipControlsRule> rules;

    private OwnershipControls(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container element for an ownership control rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The container element for an ownership control rule.
     */
    public final List<OwnershipControlsRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OwnershipControls)) {
            return false;
        }
        OwnershipControls other = (OwnershipControls) obj;
        return hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OwnershipControls").add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OwnershipControls, T> g) {
        return obj -> g.apply((OwnershipControls) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OwnershipControls> {
        /**
         * <p>
         * The container element for an ownership control rule.
         * </p>
         * 
         * @param rules
         *        The container element for an ownership control rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<OwnershipControlsRule> rules);

        /**
         * <p>
         * The container element for an ownership control rule.
         * </p>
         * 
         * @param rules
         *        The container element for an ownership control rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(OwnershipControlsRule... rules);

        /**
         * <p>
         * The container element for an ownership control rule.
         * </p>
         * This is a convenience that creates an instance of the {@link List<OwnershipControlsRule>.Builder} avoiding
         * the need to create one manually via {@link List<OwnershipControlsRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OwnershipControlsRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<OwnershipControlsRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<OwnershipControlsRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<OwnershipControlsRule>)
         */
        Builder rules(Consumer<OwnershipControlsRule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private List<OwnershipControlsRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OwnershipControls model) {
            rules(model.rules);
        }

        public final List<OwnershipControlsRule.Builder> getRules() {
            List<OwnershipControlsRule.Builder> result = OwnershipControlsRulesCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<OwnershipControlsRule.BuilderImpl> rules) {
            this.rules = OwnershipControlsRulesCopier.copyFromBuilder(rules);
        }

        @Override
        @Transient
        public final Builder rules(Collection<OwnershipControlsRule> rules) {
            this.rules = OwnershipControlsRulesCopier.copy(rules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(OwnershipControlsRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(Consumer<OwnershipControlsRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> OwnershipControlsRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OwnershipControls build() {
            return new OwnershipControls(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
