/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.http.HttpHeader;
import software.amazon.awssdk.crt.s3.S3MetaRequestResponseHandler;
import software.amazon.awssdk.http.SdkCancellationException;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.services.s3.internal.crt.S3CrtDataPublisher;

@SdkInternalApi
public class S3CrtResponseHandlerAdapter
implements S3MetaRequestResponseHandler {
    private final CompletableFuture<Void> resultFuture;
    private final SdkAsyncHttpResponseHandler responseHandler;
    private final S3CrtDataPublisher publisher;
    private final SdkHttpResponse.Builder respBuilder = SdkHttpResponse.builder();

    public S3CrtResponseHandlerAdapter(CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler) {
        this(executeFuture, responseHandler, new S3CrtDataPublisher());
    }

    @SdkTestInternalApi
    public S3CrtResponseHandlerAdapter(CompletableFuture<Void> executeFuture, SdkAsyncHttpResponseHandler responseHandler, S3CrtDataPublisher crtDataPublisher) {
        this.resultFuture = executeFuture;
        this.responseHandler = responseHandler;
        this.publisher = crtDataPublisher;
    }

    public void onResponseHeaders(int statusCode, HttpHeader[] headers) {
        for (HttpHeader h : headers) {
            this.respBuilder.appendHeader(h.getName(), h.getValue());
        }
        this.respBuilder.statusCode(statusCode);
        this.responseHandler.onHeaders((SdkHttpResponse)this.respBuilder.build());
        this.responseHandler.onStream((Publisher)this.publisher);
    }

    public int onResponseBody(ByteBuffer bodyBytesIn, long objectRangeStart, long objectRangeEnd) {
        this.publisher.deliverData(bodyBytesIn);
        return 0;
    }

    public void onFinished(int crtCode, int responseStatus, byte[] errorPayload) {
        if (crtCode != 0) {
            this.handleError(crtCode, responseStatus, errorPayload);
        } else {
            this.resultFuture.complete(null);
            this.publisher.notifyStreamingFinished();
        }
    }

    public void cancelRequest() {
        SdkCancellationException sdkClientException = new SdkCancellationException("request is cancelled");
        this.notifyError((Exception)sdkClientException);
    }

    private void handleError(int crtCode, int responseStatus, byte[] errorPayload) {
        if (S3CrtResponseHandlerAdapter.isErrorResponse(responseStatus) && errorPayload != null) {
            this.publisher.deliverData(ByteBuffer.wrap(errorPayload));
            this.publisher.notifyStreamingFinished();
            this.resultFuture.complete(null);
        } else {
            SdkClientException sdkClientException = SdkClientException.create((String)("Failed to send the request: " + CRT.awsErrorString((int)crtCode)));
            this.resultFuture.completeExceptionally((Throwable)sdkClientException);
            this.responseHandler.onError((Throwable)sdkClientException);
            this.publisher.notifyError((Exception)sdkClientException);
        }
    }

    private void notifyError(Exception exception) {
        this.resultFuture.completeExceptionally(exception);
        this.responseHandler.onError((Throwable)exception);
        this.publisher.notifyError(exception);
    }

    private static boolean isErrorResponse(int responseStatus) {
        return responseStatus != 0;
    }
}

