/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompletedMultipartUpload implements SdkPojo, Serializable,
        ToCopyableBuilder<CompletedMultipartUpload.Builder, CompletedMultipartUpload> {
    private static final SdkField<List<CompletedPart>> PARTS_FIELD = SdkField
            .<List<CompletedPart>> builder(MarshallingType.LIST)
            .getter(getter(CompletedMultipartUpload::parts))
            .setter(setter(Builder::parts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Part")
                    .unmarshallLocationName("Part").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompletedPart> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompletedPart::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<CompletedPart> parts;

    private CompletedMultipartUpload(BuilderImpl builder) {
        this.parts = builder.parts;
    }

    /**
     * Returns the value of the Parts property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the Parts property for this object.
     */
    public List<CompletedPart> parts() {
        return parts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parts());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompletedMultipartUpload)) {
            return false;
        }
        CompletedMultipartUpload other = (CompletedMultipartUpload) obj;
        return Objects.equals(parts(), other.parts());
    }

    @Override
    public String toString() {
        return ToString.builder("CompletedMultipartUpload").add("Parts", parts()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Parts":
            return Optional.ofNullable(clazz.cast(parts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CompletedMultipartUpload, T> g) {
        return obj -> g.apply((CompletedMultipartUpload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompletedMultipartUpload> {
        /**
         * Sets the value of the Parts property for this object.
         *
         * @param parts
         *        The new value for the Parts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(Collection<CompletedPart> parts);

        /**
         * Sets the value of the Parts property for this object.
         *
         * @param parts
         *        The new value for the Parts property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parts(CompletedPart... parts);

        /**
         * Sets the value of the Parts property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<CompletedPart>.Builder} avoiding the need
         * to create one manually via {@link List<CompletedPart>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CompletedPart>.Builder#build()} is called immediately and
         * its result is passed to {@link #parts(List<CompletedPart>)}.
         * 
         * @param parts
         *        a consumer that will call methods on {@link List<CompletedPart>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parts(List<CompletedPart>)
         */
        Builder parts(Consumer<CompletedPart.Builder>... parts);
    }

    static final class BuilderImpl implements Builder {
        private List<CompletedPart> parts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CompletedMultipartUpload model) {
            parts(model.parts);
        }

        public final Collection<CompletedPart.Builder> getParts() {
            return parts != null ? parts.stream().map(CompletedPart::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parts(Collection<CompletedPart> parts) {
            this.parts = CompletedPartListCopier.copy(parts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(CompletedPart... parts) {
            parts(Arrays.asList(parts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parts(Consumer<CompletedPart.Builder>... parts) {
            parts(Stream.of(parts).map(c -> CompletedPart.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setParts(Collection<CompletedPart.BuilderImpl> parts) {
            this.parts = CompletedPartListCopier.copyFromBuilder(parts);
        }

        @Override
        public CompletedMultipartUpload build() {
            return new CompletedMultipartUpload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
