/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The specified updates to the S3 Metadata journal table configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JournalTableConfigurationUpdates implements SdkPojo, Serializable,
        ToCopyableBuilder<JournalTableConfigurationUpdates.Builder, JournalTableConfigurationUpdates> {
    private static final SdkField<RecordExpiration> RECORD_EXPIRATION_FIELD = SdkField
            .<RecordExpiration> builder(MarshallingType.SDK_POJO)
            .memberName("RecordExpiration")
            .getter(getter(JournalTableConfigurationUpdates::recordExpiration))
            .setter(setter(Builder::recordExpiration))
            .constructor(RecordExpiration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordExpiration")
                    .unmarshallLocationName("RecordExpiration").build(), RequiredTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_EXPIRATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final RecordExpiration recordExpiration;

    private JournalTableConfigurationUpdates(BuilderImpl builder) {
        this.recordExpiration = builder.recordExpiration;
    }

    /**
     * <p>
     * The journal table record expiration settings for the journal table.
     * </p>
     * 
     * @return The journal table record expiration settings for the journal table.
     */
    public final RecordExpiration recordExpiration() {
        return recordExpiration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordExpiration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JournalTableConfigurationUpdates)) {
            return false;
        }
        JournalTableConfigurationUpdates other = (JournalTableConfigurationUpdates) obj;
        return Objects.equals(recordExpiration(), other.recordExpiration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JournalTableConfigurationUpdates").add("RecordExpiration", recordExpiration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecordExpiration":
            return Optional.ofNullable(clazz.cast(recordExpiration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RecordExpiration", RECORD_EXPIRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JournalTableConfigurationUpdates, T> g) {
        return obj -> g.apply((JournalTableConfigurationUpdates) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JournalTableConfigurationUpdates> {
        /**
         * <p>
         * The journal table record expiration settings for the journal table.
         * </p>
         * 
         * @param recordExpiration
         *        The journal table record expiration settings for the journal table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordExpiration(RecordExpiration recordExpiration);

        /**
         * <p>
         * The journal table record expiration settings for the journal table.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecordExpiration.Builder} avoiding the
         * need to create one manually via {@link RecordExpiration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecordExpiration.Builder#build()} is called immediately and its
         * result is passed to {@link #recordExpiration(RecordExpiration)}.
         * 
         * @param recordExpiration
         *        a consumer that will call methods on {@link RecordExpiration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recordExpiration(RecordExpiration)
         */
        default Builder recordExpiration(Consumer<RecordExpiration.Builder> recordExpiration) {
            return recordExpiration(RecordExpiration.builder().applyMutation(recordExpiration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RecordExpiration recordExpiration;

        private BuilderImpl() {
        }

        private BuilderImpl(JournalTableConfigurationUpdates model) {
            recordExpiration(model.recordExpiration);
        }

        public final RecordExpiration.Builder getRecordExpiration() {
            return recordExpiration != null ? recordExpiration.toBuilder() : null;
        }

        public final void setRecordExpiration(RecordExpiration.BuilderImpl recordExpiration) {
            this.recordExpiration = recordExpiration != null ? recordExpiration.build() : null;
        }

        @Override
        public final Builder recordExpiration(RecordExpiration recordExpiration) {
            this.recordExpiration = recordExpiration;
            return this;
        }

        @Override
        public JournalTableConfigurationUpdates build() {
            return new JournalTableConfigurationUpdates(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
