/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3TablesBucketType {
    AWS("aws"),
    CUSTOMER("customer"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3TablesBucketType> VALUE_MAP;
    private final String value;

    private S3TablesBucketType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3TablesBucketType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3TablesBucketType> knownValues() {
        EnumSet<S3TablesBucketType> knownValues = EnumSet.allOf(S3TablesBucketType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3TablesBucketType.class, S3TablesBucketType::toString);
    }
}

