/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for specifying the notification configuration of the bucket. If this element is empty, notifications are
 * turned off for the bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBucketNotificationConfigurationResponse extends S3Response implements
        ToCopyableBuilder<GetBucketNotificationConfigurationResponse.Builder, GetBucketNotificationConfigurationResponse> {
    private static final SdkField<List<TopicConfiguration>> TOPIC_CONFIGURATIONS_FIELD = SdkField
            .<List<TopicConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(GetBucketNotificationConfigurationResponse::topicConfigurations))
            .setter(setter(Builder::topicConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TopicConfiguration")
                    .unmarshallLocationName("TopicConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TopicConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(TopicConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final SdkField<List<QueueConfiguration>> QUEUE_CONFIGURATIONS_FIELD = SdkField
            .<List<QueueConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(GetBucketNotificationConfigurationResponse::queueConfigurations))
            .setter(setter(Builder::queueConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueueConfiguration")
                    .unmarshallLocationName("QueueConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueueConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueueConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final SdkField<List<LambdaFunctionConfiguration>> LAMBDA_FUNCTION_CONFIGURATIONS_FIELD = SdkField
            .<List<LambdaFunctionConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(GetBucketNotificationConfigurationResponse::lambdaFunctionConfigurations))
            .setter(setter(Builder::lambdaFunctionConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudFunctionConfiguration")
                    .unmarshallLocationName("CloudFunctionConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LambdaFunctionConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LambdaFunctionConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .isFlattened(true).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_CONFIGURATIONS_FIELD,
            QUEUE_CONFIGURATIONS_FIELD, LAMBDA_FUNCTION_CONFIGURATIONS_FIELD));

    private final List<TopicConfiguration> topicConfigurations;

    private final List<QueueConfiguration> queueConfigurations;

    private final List<LambdaFunctionConfiguration> lambdaFunctionConfigurations;

    private GetBucketNotificationConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.topicConfigurations = builder.topicConfigurations;
        this.queueConfigurations = builder.queueConfigurations;
        this.lambdaFunctionConfigurations = builder.lambdaFunctionConfigurations;
    }

    /**
     * Returns the value of the TopicConfigurations property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the TopicConfigurations property for this object.
     */
    public List<TopicConfiguration> topicConfigurations() {
        return topicConfigurations;
    }

    /**
     * Returns the value of the QueueConfigurations property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the QueueConfigurations property for this object.
     */
    public List<QueueConfiguration> queueConfigurations() {
        return queueConfigurations;
    }

    /**
     * Returns the value of the LambdaFunctionConfigurations property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the LambdaFunctionConfigurations property for this object.
     */
    public List<LambdaFunctionConfiguration> lambdaFunctionConfigurations() {
        return lambdaFunctionConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topicConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(queueConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaFunctionConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBucketNotificationConfigurationResponse)) {
            return false;
        }
        GetBucketNotificationConfigurationResponse other = (GetBucketNotificationConfigurationResponse) obj;
        return Objects.equals(topicConfigurations(), other.topicConfigurations())
                && Objects.equals(queueConfigurations(), other.queueConfigurations())
                && Objects.equals(lambdaFunctionConfigurations(), other.lambdaFunctionConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetBucketNotificationConfigurationResponse").add("TopicConfigurations", topicConfigurations())
                .add("QueueConfigurations", queueConfigurations())
                .add("LambdaFunctionConfigurations", lambdaFunctionConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TopicConfigurations":
            return Optional.ofNullable(clazz.cast(topicConfigurations()));
        case "QueueConfigurations":
            return Optional.ofNullable(clazz.cast(queueConfigurations()));
        case "LambdaFunctionConfigurations":
            return Optional.ofNullable(clazz.cast(lambdaFunctionConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBucketNotificationConfigurationResponse, T> g) {
        return obj -> g.apply((GetBucketNotificationConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Response.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBucketNotificationConfigurationResponse> {
        /**
         * Sets the value of the TopicConfigurations property for this object.
         *
         * @param topicConfigurations
         *        The new value for the TopicConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurations(Collection<TopicConfiguration> topicConfigurations);

        /**
         * Sets the value of the TopicConfigurations property for this object.
         *
         * @param topicConfigurations
         *        The new value for the TopicConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicConfigurations(TopicConfiguration... topicConfigurations);

        /**
         * Sets the value of the TopicConfigurations property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<TopicConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<TopicConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TopicConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #topicConfigurations(List<TopicConfiguration>)}.
         * 
         * @param topicConfigurations
         *        a consumer that will call methods on {@link List<TopicConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #topicConfigurations(List<TopicConfiguration>)
         */
        Builder topicConfigurations(Consumer<TopicConfiguration.Builder>... topicConfigurations);

        /**
         * Sets the value of the QueueConfigurations property for this object.
         *
         * @param queueConfigurations
         *        The new value for the QueueConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfigurations(Collection<QueueConfiguration> queueConfigurations);

        /**
         * Sets the value of the QueueConfigurations property for this object.
         *
         * @param queueConfigurations
         *        The new value for the QueueConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueConfigurations(QueueConfiguration... queueConfigurations);

        /**
         * Sets the value of the QueueConfigurations property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<QueueConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<QueueConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<QueueConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #queueConfigurations(List<QueueConfiguration>)}.
         * 
         * @param queueConfigurations
         *        a consumer that will call methods on {@link List<QueueConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueConfigurations(List<QueueConfiguration>)
         */
        Builder queueConfigurations(Consumer<QueueConfiguration.Builder>... queueConfigurations);

        /**
         * Sets the value of the LambdaFunctionConfigurations property for this object.
         *
         * @param lambdaFunctionConfigurations
         *        The new value for the LambdaFunctionConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionConfigurations(Collection<LambdaFunctionConfiguration> lambdaFunctionConfigurations);

        /**
         * Sets the value of the LambdaFunctionConfigurations property for this object.
         *
         * @param lambdaFunctionConfigurations
         *        The new value for the LambdaFunctionConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaFunctionConfigurations(LambdaFunctionConfiguration... lambdaFunctionConfigurations);

        /**
         * Sets the value of the LambdaFunctionConfigurations property for this object.
         *
         * This is a convenience that creates an instance of the {@link List<LambdaFunctionConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<LambdaFunctionConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LambdaFunctionConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #lambdaFunctionConfigurations(List<LambdaFunctionConfiguration>)}.
         * 
         * @param lambdaFunctionConfigurations
         *        a consumer that will call methods on {@link List<LambdaFunctionConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaFunctionConfigurations(List<LambdaFunctionConfiguration>)
         */
        Builder lambdaFunctionConfigurations(Consumer<LambdaFunctionConfiguration.Builder>... lambdaFunctionConfigurations);
    }

    static final class BuilderImpl extends S3Response.BuilderImpl implements Builder {
        private List<TopicConfiguration> topicConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<QueueConfiguration> queueConfigurations = DefaultSdkAutoConstructList.getInstance();

        private List<LambdaFunctionConfiguration> lambdaFunctionConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetBucketNotificationConfigurationResponse model) {
            super(model);
            topicConfigurations(model.topicConfigurations);
            queueConfigurations(model.queueConfigurations);
            lambdaFunctionConfigurations(model.lambdaFunctionConfigurations);
        }

        public final Collection<TopicConfiguration.Builder> getTopicConfigurations() {
            return topicConfigurations != null ? topicConfigurations.stream().map(TopicConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder topicConfigurations(Collection<TopicConfiguration> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationListCopier.copy(topicConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurations(TopicConfiguration... topicConfigurations) {
            topicConfigurations(Arrays.asList(topicConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topicConfigurations(Consumer<TopicConfiguration.Builder>... topicConfigurations) {
            topicConfigurations(Stream.of(topicConfigurations).map(c -> TopicConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTopicConfigurations(Collection<TopicConfiguration.BuilderImpl> topicConfigurations) {
            this.topicConfigurations = TopicConfigurationListCopier.copyFromBuilder(topicConfigurations);
        }

        public final Collection<QueueConfiguration.Builder> getQueueConfigurations() {
            return queueConfigurations != null ? queueConfigurations.stream().map(QueueConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder queueConfigurations(Collection<QueueConfiguration> queueConfigurations) {
            this.queueConfigurations = QueueConfigurationListCopier.copy(queueConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigurations(QueueConfiguration... queueConfigurations) {
            queueConfigurations(Arrays.asList(queueConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueConfigurations(Consumer<QueueConfiguration.Builder>... queueConfigurations) {
            queueConfigurations(Stream.of(queueConfigurations).map(c -> QueueConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setQueueConfigurations(Collection<QueueConfiguration.BuilderImpl> queueConfigurations) {
            this.queueConfigurations = QueueConfigurationListCopier.copyFromBuilder(queueConfigurations);
        }

        public final Collection<LambdaFunctionConfiguration.Builder> getLambdaFunctionConfigurations() {
            return lambdaFunctionConfigurations != null ? lambdaFunctionConfigurations.stream()
                    .map(LambdaFunctionConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder lambdaFunctionConfigurations(Collection<LambdaFunctionConfiguration> lambdaFunctionConfigurations) {
            this.lambdaFunctionConfigurations = LambdaFunctionConfigurationListCopier.copy(lambdaFunctionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionConfigurations(LambdaFunctionConfiguration... lambdaFunctionConfigurations) {
            lambdaFunctionConfigurations(Arrays.asList(lambdaFunctionConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lambdaFunctionConfigurations(
                Consumer<LambdaFunctionConfiguration.Builder>... lambdaFunctionConfigurations) {
            lambdaFunctionConfigurations(Stream.of(lambdaFunctionConfigurations)
                    .map(c -> LambdaFunctionConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLambdaFunctionConfigurations(
                Collection<LambdaFunctionConfiguration.BuilderImpl> lambdaFunctionConfigurations) {
            this.lambdaFunctionConfigurations = LambdaFunctionConfigurationListCopier
                    .copyFromBuilder(lambdaFunctionConfigurations);
        }

        @Override
        public GetBucketNotificationConfigurationResponse build() {
            return new GetBucketNotificationConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
