/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.ReplicationConfiguration;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutBucketReplicationRequest
extends S3Request
implements ToCopyableBuilder<Builder, PutBucketReplicationRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutBucketReplicationRequest.getter(PutBucketReplicationRequest::bucket)).setter(PutBucketReplicationRequest.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket").unmarshallLocationName("Bucket").build()}).build();
    private static final SdkField<String> CONTENT_MD5_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutBucketReplicationRequest.getter(PutBucketReplicationRequest::contentMD5)).setter(PutBucketReplicationRequest.setter(Builder::contentMD5)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-MD5").unmarshallLocationName("Content-MD5").build()}).build();
    private static final SdkField<ReplicationConfiguration> REPLICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(PutBucketReplicationRequest.getter(PutBucketReplicationRequest::replicationConfiguration)).setter(PutBucketReplicationRequest.setter(Builder::replicationConfiguration)).constructor(ReplicationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfiguration").unmarshallLocationName("ReplicationConfiguration").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, CONTENT_MD5_FIELD, REPLICATION_CONFIGURATION_FIELD));
    private final String bucket;
    private final String contentMD5;
    private final ReplicationConfiguration replicationConfiguration;

    private PutBucketReplicationRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.contentMD5 = builder.contentMD5;
        this.replicationConfiguration = builder.replicationConfiguration;
    }

    public String bucket() {
        return this.bucket;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public ReplicationConfiguration replicationConfiguration() {
        return this.replicationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutBucketReplicationRequest)) {
            return false;
        }
        PutBucketReplicationRequest other = (PutBucketReplicationRequest)((Object)obj);
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.contentMD5(), other.contentMD5()) && Objects.equals(this.replicationConfiguration(), other.replicationConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"PutBucketReplicationRequest").add("Bucket", (Object)this.bucket()).add("ContentMD5", (Object)this.contentMD5()).add("ReplicationConfiguration", (Object)this.replicationConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "ContentMD5": {
                return Optional.ofNullable(clazz.cast(this.contentMD5()));
            }
            case "ReplicationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.replicationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutBucketReplicationRequest, T> g) {
        return obj -> g.apply((PutBucketReplicationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String bucket;
        private String contentMD5;
        private ReplicationConfiguration replicationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(PutBucketReplicationRequest model) {
            super(model);
            this.bucket(model.bucket);
            this.contentMD5(model.contentMD5);
            this.replicationConfiguration(model.replicationConfiguration);
        }

        public final String getBucket() {
            return this.bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getContentMD5() {
            return this.contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final ReplicationConfiguration.Builder getReplicationConfiguration() {
            return this.replicationConfiguration != null ? this.replicationConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder replicationConfiguration(ReplicationConfiguration replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration;
            return this;
        }

        public final void setReplicationConfiguration(ReplicationConfiguration.BuilderImpl replicationConfiguration) {
            this.replicationConfiguration = replicationConfiguration != null ? replicationConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutBucketReplicationRequest build() {
            return new PutBucketReplicationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends S3Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutBucketReplicationRequest> {
        public Builder bucket(String var1);

        public Builder contentMD5(String var1);

        public Builder replicationConfiguration(ReplicationConfiguration var1);

        default public Builder replicationConfiguration(Consumer<ReplicationConfiguration.Builder> replicationConfiguration) {
            return this.replicationConfiguration((ReplicationConfiguration)((ReplicationConfiguration.Builder)ReplicationConfiguration.builder().applyMutation(replicationConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

