/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.internal.EndpointUtils;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.protocols.core.OperationInfo;
import software.amazon.awssdk.protocols.core.PathMarshaller;
import software.amazon.awssdk.protocols.core.ProtocolUtils;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.internal.S3EndpointUtils;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.utils.Validate;

@Immutable
@SdkPublicApi
public final class S3Utilities {
    private final Region region;
    private final S3Configuration s3Configuration;

    private S3Utilities(Builder builder) {
        this.region = (Region)Validate.paramNotNull((Object)builder.region, (String)"Region");
        this.s3Configuration = builder.s3Configuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    @SdkInternalApi
    static S3Utilities create(SdkClientConfiguration clientConfiguration) {
        return S3Utilities.builder().region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).s3Configuration((S3Configuration)clientConfiguration.option((ClientOption)SdkClientOption.SERVICE_CONFIGURATION)).build();
    }

    public URL getUrl(Consumer<GetUrlRequest.Builder> getUrlRequest) {
        return this.getUrl((GetUrlRequest)((GetUrlRequest.Builder)GetUrlRequest.builder().applyMutation(getUrlRequest)).build());
    }

    public URL getUrl(GetUrlRequest getUrlRequest) {
        Region resolvedRegion = this.resolveRegionForGetUrl(getUrlRequest);
        URI resolvedEndpoint = this.resolveEndpoint(getUrlRequest.endpoint(), resolvedRegion);
        SdkHttpFullRequest marshalledRequest = this.createMarshalledRequest(getUrlRequest, resolvedEndpoint);
        SdkHttpRequest httpRequest = S3EndpointUtils.applyEndpointConfiguration((SdkHttpRequest)marshalledRequest, getUrlRequest, resolvedRegion, this.s3Configuration, getUrlRequest.bucket());
        try {
            return httpRequest.getUri().toURL();
        }
        catch (MalformedURLException exception) {
            throw SdkException.create((String)String.format("Generated URI is malformed: " + httpRequest.getUri(), new Object[0]), (Throwable)exception);
        }
    }

    private Region resolveRegionForGetUrl(GetUrlRequest getUrlRequest) {
        if (getUrlRequest.region() == null && this.region == null) {
            throw new IllegalArgumentException("Region should be provided either in GetUrlRequest object or S3Utilities object");
        }
        return getUrlRequest.region() != null ? getUrlRequest.region() : this.region;
    }

    private URI resolveEndpoint(URI endpoint, Region region) {
        return endpoint != null ? endpoint : EndpointUtils.buildEndpoint((String)"https", (String)"s3", (Region)region);
    }

    private SdkHttpFullRequest createMarshalledRequest(GetUrlRequest getUrlRequest, URI endpoint) {
        OperationInfo operationInfo = OperationInfo.builder().requestUri("/{Bucket}/{Key+}").httpMethod(SdkHttpMethod.HEAD).build();
        SdkHttpFullRequest.Builder builder = ProtocolUtils.createSdkHttpRequest((OperationInfo)operationInfo, (URI)endpoint);
        builder.encodedPath(PathMarshaller.NON_GREEDY.marshall(builder.encodedPath(), "Bucket", getUrlRequest.bucket()));
        builder.encodedPath(PathMarshaller.GREEDY.marshall(builder.encodedPath(), "Key", getUrlRequest.key()));
        return builder.build();
    }

    public static final class Builder {
        private Region region;
        private S3Configuration s3Configuration;

        private Builder() {
        }

        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        public Builder s3Configuration(S3Configuration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public S3Utilities build() {
            return new S3Utilities(this);
        }
    }
}

