/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutObjectRetentionRequest extends S3Request implements
        ToCopyableBuilder<PutObjectRetentionRequest.Builder, PutObjectRetentionRequest> {
    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRetentionRequest::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRetentionRequest::key))
            .setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("Key")
                    .unmarshallLocationName("Key").build()).build();

    private static final SdkField<ObjectLockRetention> RETENTION_FIELD = SdkField
            .<ObjectLockRetention> builder(MarshallingType.SDK_POJO)
            .getter(getter(PutObjectRetentionRequest::retention))
            .setter(setter(Builder::retention))
            .constructor(ObjectLockRetention::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention")
                    .unmarshallLocationName("Retention").build(), PayloadTrait.create()).build();

    private static final SdkField<String> REQUEST_PAYER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRetentionRequest::requestPayerAsString))
            .setter(setter(Builder::requestPayer))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-request-payer")
                    .unmarshallLocationName("x-amz-request-payer").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRetentionRequest::versionId))
            .setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("versionId")
                    .unmarshallLocationName("versionId").build()).build();

    private static final SdkField<Boolean> BYPASS_GOVERNANCE_RETENTION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PutObjectRetentionRequest::bypassGovernanceRetention))
            .setter(setter(Builder::bypassGovernanceRetention))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-bypass-governance-retention")
                    .unmarshallLocationName("x-amz-bypass-governance-retention").build()).build();

    private static final SdkField<String> CONTENT_MD5_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRetentionRequest::contentMD5))
            .setter(setter(Builder::contentMD5))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-MD5")
                    .unmarshallLocationName("Content-MD5").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, KEY_FIELD,
            RETENTION_FIELD, REQUEST_PAYER_FIELD, VERSION_ID_FIELD, BYPASS_GOVERNANCE_RETENTION_FIELD, CONTENT_MD5_FIELD));

    private final String bucket;

    private final String key;

    private final ObjectLockRetention retention;

    private final String requestPayer;

    private final String versionId;

    private final Boolean bypassGovernanceRetention;

    private final String contentMD5;

    private PutObjectRetentionRequest(BuilderImpl builder) {
        super(builder);
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.retention = builder.retention;
        this.requestPayer = builder.requestPayer;
        this.versionId = builder.versionId;
        this.bypassGovernanceRetention = builder.bypassGovernanceRetention;
        this.contentMD5 = builder.contentMD5;
    }

    /**
     * <p>
     * The bucket that contains the object you want to apply this Object Retention configuration to.
     * </p>
     * 
     * @return The bucket that contains the object you want to apply this Object Retention configuration to.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The key name for the object that you want to apply this Object Retention configuration to.
     * </p>
     * 
     * @return The key name for the object that you want to apply this Object Retention configuration to.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The container element for the Object Retention configuration.
     * </p>
     * 
     * @return The container element for the Object Retention configuration.
     */
    public ObjectLockRetention retention() {
        return retention;
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerAsString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public RequestPayer requestPayer() {
        return RequestPayer.fromValue(requestPayer);
    }

    /**
     * Returns the value of the RequestPayer property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #requestPayer} will
     * return {@link RequestPayer#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #requestPayerAsString}.
     * </p>
     * 
     * @return The value of the RequestPayer property for this object.
     * @see RequestPayer
     */
    public String requestPayerAsString() {
        return requestPayer;
    }

    /**
     * <p>
     * The version ID for the object that you want to apply this Object Retention configuration to.
     * </p>
     * 
     * @return The version ID for the object that you want to apply this Object Retention configuration to.
     */
    public String versionId() {
        return versionId;
    }

    /**
     * <p>
     * Indicates whether this operation should bypass Governance-mode restrictions.j
     * </p>
     * 
     * @return Indicates whether this operation should bypass Governance-mode restrictions.j
     */
    public Boolean bypassGovernanceRetention() {
        return bypassGovernanceRetention;
    }

    /**
     * <p>
     * The MD5 hash for the request body.
     * </p>
     * 
     * @return The MD5 hash for the request body.
     */
    public String contentMD5() {
        return contentMD5;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(retention());
        hashCode = 31 * hashCode + Objects.hashCode(requestPayerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        hashCode = 31 * hashCode + Objects.hashCode(bypassGovernanceRetention());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectRetentionRequest)) {
            return false;
        }
        PutObjectRetentionRequest other = (PutObjectRetentionRequest) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(key(), other.key())
                && Objects.equals(retention(), other.retention())
                && Objects.equals(requestPayerAsString(), other.requestPayerAsString())
                && Objects.equals(versionId(), other.versionId())
                && Objects.equals(bypassGovernanceRetention(), other.bypassGovernanceRetention())
                && Objects.equals(contentMD5(), other.contentMD5());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutObjectRetentionRequest").add("Bucket", bucket()).add("Key", key())
                .add("Retention", retention()).add("RequestPayer", requestPayerAsString()).add("VersionId", versionId())
                .add("BypassGovernanceRetention", bypassGovernanceRetention()).add("ContentMD5", contentMD5()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Retention":
            return Optional.ofNullable(clazz.cast(retention()));
        case "RequestPayer":
            return Optional.ofNullable(clazz.cast(requestPayerAsString()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        case "BypassGovernanceRetention":
            return Optional.ofNullable(clazz.cast(bypassGovernanceRetention()));
        case "ContentMD5":
            return Optional.ofNullable(clazz.cast(contentMD5()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectRetentionRequest, T> g) {
        return obj -> g.apply((PutObjectRetentionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3Request.Builder, SdkPojo, CopyableBuilder<Builder, PutObjectRetentionRequest> {
        /**
         * <p>
         * The bucket that contains the object you want to apply this Object Retention configuration to.
         * </p>
         * 
         * @param bucket
         *        The bucket that contains the object you want to apply this Object Retention configuration to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The key name for the object that you want to apply this Object Retention configuration to.
         * </p>
         * 
         * @param key
         *        The key name for the object that you want to apply this Object Retention configuration to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The container element for the Object Retention configuration.
         * </p>
         * 
         * @param retention
         *        The container element for the Object Retention configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retention(ObjectLockRetention retention);

        /**
         * <p>
         * The container element for the Object Retention configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectLockRetention.Builder} avoiding the need
         * to create one manually via {@link ObjectLockRetention#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectLockRetention.Builder#build()} is called immediately and
         * its result is passed to {@link #retention(ObjectLockRetention)}.
         * 
         * @param retention
         *        a consumer that will call methods on {@link ObjectLockRetention.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retention(ObjectLockRetention)
         */
        default Builder retention(Consumer<ObjectLockRetention.Builder> retention) {
            return retention(ObjectLockRetention.builder().applyMutation(retention).build());
        }

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(String requestPayer);

        /**
         * Sets the value of the RequestPayer property for this object.
         *
         * @param requestPayer
         *        The new value for the RequestPayer property for this object.
         * @see RequestPayer
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestPayer
         */
        Builder requestPayer(RequestPayer requestPayer);

        /**
         * <p>
         * The version ID for the object that you want to apply this Object Retention configuration to.
         * </p>
         * 
         * @param versionId
         *        The version ID for the object that you want to apply this Object Retention configuration to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);

        /**
         * <p>
         * Indicates whether this operation should bypass Governance-mode restrictions.j
         * </p>
         * 
         * @param bypassGovernanceRetention
         *        Indicates whether this operation should bypass Governance-mode restrictions.j
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention);

        /**
         * <p>
         * The MD5 hash for the request body.
         * </p>
         * 
         * @param contentMD5
         *        The MD5 hash for the request body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3Request.BuilderImpl implements Builder {
        private String bucket;

        private String key;

        private ObjectLockRetention retention;

        private String requestPayer;

        private String versionId;

        private Boolean bypassGovernanceRetention;

        private String contentMD5;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectRetentionRequest model) {
            super(model);
            bucket(model.bucket);
            key(model.key);
            retention(model.retention);
            requestPayer(model.requestPayer);
            versionId(model.versionId);
            bypassGovernanceRetention(model.bypassGovernanceRetention);
            contentMD5(model.contentMD5);
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final ObjectLockRetention.Builder getRetention() {
            return retention != null ? retention.toBuilder() : null;
        }

        @Override
        public final Builder retention(ObjectLockRetention retention) {
            this.retention = retention;
            return this;
        }

        public final void setRetention(ObjectLockRetention.BuilderImpl retention) {
            this.retention = retention != null ? retention.build() : null;
        }

        public final String getRequestPayerAsString() {
            return requestPayer;
        }

        @Override
        public final Builder requestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
            return this;
        }

        @Override
        public final Builder requestPayer(RequestPayer requestPayer) {
            this.requestPayer(requestPayer.toString());
            return this;
        }

        public final void setRequestPayer(String requestPayer) {
            this.requestPayer = requestPayer;
        }

        public final String getVersionId() {
            return versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        public final Boolean getBypassGovernanceRetention() {
            return bypassGovernanceRetention;
        }

        @Override
        public final Builder bypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
            return this;
        }

        public final void setBypassGovernanceRetention(Boolean bypassGovernanceRetention) {
            this.bypassGovernanceRetention = bypassGovernanceRetention;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutObjectRetentionRequest build() {
            return new PutObjectRetentionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
