/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how a CSV-formatted input object is formatted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CSVInput implements SdkPojo, Serializable, ToCopyableBuilder<CSVInput.Builder, CSVInput> {
    private static final SdkField<String> FILE_HEADER_INFO_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CSVInput::fileHeaderInfoAsString))
            .setter(setter(Builder::fileHeaderInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileHeaderInfo")
                    .unmarshallLocationName("FileHeaderInfo").build()).build();

    private static final SdkField<String> COMMENTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CSVInput::comments))
            .setter(setter(Builder::comments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comments")
                    .unmarshallLocationName("Comments").build()).build();

    private static final SdkField<String> QUOTE_ESCAPE_CHARACTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CSVInput::quoteEscapeCharacter))
            .setter(setter(Builder::quoteEscapeCharacter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteEscapeCharacter")
                    .unmarshallLocationName("QuoteEscapeCharacter").build()).build();

    private static final SdkField<String> RECORD_DELIMITER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CSVInput::recordDelimiter))
            .setter(setter(Builder::recordDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordDelimiter")
                    .unmarshallLocationName("RecordDelimiter").build()).build();

    private static final SdkField<String> FIELD_DELIMITER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CSVInput::fieldDelimiter))
            .setter(setter(Builder::fieldDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldDelimiter")
                    .unmarshallLocationName("FieldDelimiter").build()).build();

    private static final SdkField<String> QUOTE_CHARACTER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CSVInput::quoteCharacter))
            .setter(setter(Builder::quoteCharacter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteCharacter")
                    .unmarshallLocationName("QuoteCharacter").build()).build();

    private static final SdkField<Boolean> ALLOW_QUOTED_RECORD_DELIMITER_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CSVInput::allowQuotedRecordDelimiter))
            .setter(setter(Builder::allowQuotedRecordDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowQuotedRecordDelimiter")
                    .unmarshallLocationName("AllowQuotedRecordDelimiter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_HEADER_INFO_FIELD,
            COMMENTS_FIELD, QUOTE_ESCAPE_CHARACTER_FIELD, RECORD_DELIMITER_FIELD, FIELD_DELIMITER_FIELD, QUOTE_CHARACTER_FIELD,
            ALLOW_QUOTED_RECORD_DELIMITER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileHeaderInfo;

    private final String comments;

    private final String quoteEscapeCharacter;

    private final String recordDelimiter;

    private final String fieldDelimiter;

    private final String quoteCharacter;

    private final Boolean allowQuotedRecordDelimiter;

    private CSVInput(BuilderImpl builder) {
        this.fileHeaderInfo = builder.fileHeaderInfo;
        this.comments = builder.comments;
        this.quoteEscapeCharacter = builder.quoteEscapeCharacter;
        this.recordDelimiter = builder.recordDelimiter;
        this.fieldDelimiter = builder.fieldDelimiter;
        this.quoteCharacter = builder.quoteCharacter;
        this.allowQuotedRecordDelimiter = builder.allowQuotedRecordDelimiter;
    }

    /**
     * <p>
     * Describes the first line of input. Valid values: None, Ignore, Use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileHeaderInfo}
     * will return {@link FileHeaderInfo#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileHeaderInfoAsString}.
     * </p>
     * 
     * @return Describes the first line of input. Valid values: None, Ignore, Use.
     * @see FileHeaderInfo
     */
    public FileHeaderInfo fileHeaderInfo() {
        return FileHeaderInfo.fromValue(fileHeaderInfo);
    }

    /**
     * <p>
     * Describes the first line of input. Valid values: None, Ignore, Use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileHeaderInfo}
     * will return {@link FileHeaderInfo#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileHeaderInfoAsString}.
     * </p>
     * 
     * @return Describes the first line of input. Valid values: None, Ignore, Use.
     * @see FileHeaderInfo
     */
    public String fileHeaderInfoAsString() {
        return fileHeaderInfo;
    }

    /**
     * <p>
     * The single character used to indicate a row should be ignored when present at the start of a row.
     * </p>
     * 
     * @return The single character used to indicate a row should be ignored when present at the start of a row.
     */
    public String comments() {
        return comments;
    }

    /**
     * <p>
     * The single character used for escaping the quote character inside an already escaped value.
     * </p>
     * 
     * @return The single character used for escaping the quote character inside an already escaped value.
     */
    public String quoteEscapeCharacter() {
        return quoteEscapeCharacter;
    }

    /**
     * <p>
     * The value used to separate individual records.
     * </p>
     * 
     * @return The value used to separate individual records.
     */
    public String recordDelimiter() {
        return recordDelimiter;
    }

    /**
     * <p>
     * The value used to separate individual fields in a record.
     * </p>
     * 
     * @return The value used to separate individual fields in a record.
     */
    public String fieldDelimiter() {
        return fieldDelimiter;
    }

    /**
     * <p>
     * Value used for escaping where the field delimiter is part of the value.
     * </p>
     * 
     * @return Value used for escaping where the field delimiter is part of the value.
     */
    public String quoteCharacter() {
        return quoteCharacter;
    }

    /**
     * <p>
     * Specifies that CSV field values may contain quoted record delimiters and such records should be allowed. Default
     * value is FALSE. Setting this value to TRUE may lower performance.
     * </p>
     * 
     * @return Specifies that CSV field values may contain quoted record delimiters and such records should be allowed.
     *         Default value is FALSE. Setting this value to TRUE may lower performance.
     */
    public Boolean allowQuotedRecordDelimiter() {
        return allowQuotedRecordDelimiter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileHeaderInfoAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comments());
        hashCode = 31 * hashCode + Objects.hashCode(quoteEscapeCharacter());
        hashCode = 31 * hashCode + Objects.hashCode(recordDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(fieldDelimiter());
        hashCode = 31 * hashCode + Objects.hashCode(quoteCharacter());
        hashCode = 31 * hashCode + Objects.hashCode(allowQuotedRecordDelimiter());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CSVInput)) {
            return false;
        }
        CSVInput other = (CSVInput) obj;
        return Objects.equals(fileHeaderInfoAsString(), other.fileHeaderInfoAsString())
                && Objects.equals(comments(), other.comments())
                && Objects.equals(quoteEscapeCharacter(), other.quoteEscapeCharacter())
                && Objects.equals(recordDelimiter(), other.recordDelimiter())
                && Objects.equals(fieldDelimiter(), other.fieldDelimiter())
                && Objects.equals(quoteCharacter(), other.quoteCharacter())
                && Objects.equals(allowQuotedRecordDelimiter(), other.allowQuotedRecordDelimiter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CSVInput").add("FileHeaderInfo", fileHeaderInfoAsString()).add("Comments", comments())
                .add("QuoteEscapeCharacter", quoteEscapeCharacter()).add("RecordDelimiter", recordDelimiter())
                .add("FieldDelimiter", fieldDelimiter()).add("QuoteCharacter", quoteCharacter())
                .add("AllowQuotedRecordDelimiter", allowQuotedRecordDelimiter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileHeaderInfo":
            return Optional.ofNullable(clazz.cast(fileHeaderInfoAsString()));
        case "Comments":
            return Optional.ofNullable(clazz.cast(comments()));
        case "QuoteEscapeCharacter":
            return Optional.ofNullable(clazz.cast(quoteEscapeCharacter()));
        case "RecordDelimiter":
            return Optional.ofNullable(clazz.cast(recordDelimiter()));
        case "FieldDelimiter":
            return Optional.ofNullable(clazz.cast(fieldDelimiter()));
        case "QuoteCharacter":
            return Optional.ofNullable(clazz.cast(quoteCharacter()));
        case "AllowQuotedRecordDelimiter":
            return Optional.ofNullable(clazz.cast(allowQuotedRecordDelimiter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CSVInput, T> g) {
        return obj -> g.apply((CSVInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CSVInput> {
        /**
         * <p>
         * Describes the first line of input. Valid values: None, Ignore, Use.
         * </p>
         * 
         * @param fileHeaderInfo
         *        Describes the first line of input. Valid values: None, Ignore, Use.
         * @see FileHeaderInfo
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileHeaderInfo
         */
        Builder fileHeaderInfo(String fileHeaderInfo);

        /**
         * <p>
         * Describes the first line of input. Valid values: None, Ignore, Use.
         * </p>
         * 
         * @param fileHeaderInfo
         *        Describes the first line of input. Valid values: None, Ignore, Use.
         * @see FileHeaderInfo
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileHeaderInfo
         */
        Builder fileHeaderInfo(FileHeaderInfo fileHeaderInfo);

        /**
         * <p>
         * The single character used to indicate a row should be ignored when present at the start of a row.
         * </p>
         * 
         * @param comments
         *        The single character used to indicate a row should be ignored when present at the start of a row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comments(String comments);

        /**
         * <p>
         * The single character used for escaping the quote character inside an already escaped value.
         * </p>
         * 
         * @param quoteEscapeCharacter
         *        The single character used for escaping the quote character inside an already escaped value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quoteEscapeCharacter(String quoteEscapeCharacter);

        /**
         * <p>
         * The value used to separate individual records.
         * </p>
         * 
         * @param recordDelimiter
         *        The value used to separate individual records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordDelimiter(String recordDelimiter);

        /**
         * <p>
         * The value used to separate individual fields in a record.
         * </p>
         * 
         * @param fieldDelimiter
         *        The value used to separate individual fields in a record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldDelimiter(String fieldDelimiter);

        /**
         * <p>
         * Value used for escaping where the field delimiter is part of the value.
         * </p>
         * 
         * @param quoteCharacter
         *        Value used for escaping where the field delimiter is part of the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quoteCharacter(String quoteCharacter);

        /**
         * <p>
         * Specifies that CSV field values may contain quoted record delimiters and such records should be allowed.
         * Default value is FALSE. Setting this value to TRUE may lower performance.
         * </p>
         * 
         * @param allowQuotedRecordDelimiter
         *        Specifies that CSV field values may contain quoted record delimiters and such records should be
         *        allowed. Default value is FALSE. Setting this value to TRUE may lower performance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowQuotedRecordDelimiter(Boolean allowQuotedRecordDelimiter);
    }

    static final class BuilderImpl implements Builder {
        private String fileHeaderInfo;

        private String comments;

        private String quoteEscapeCharacter;

        private String recordDelimiter;

        private String fieldDelimiter;

        private String quoteCharacter;

        private Boolean allowQuotedRecordDelimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(CSVInput model) {
            fileHeaderInfo(model.fileHeaderInfo);
            comments(model.comments);
            quoteEscapeCharacter(model.quoteEscapeCharacter);
            recordDelimiter(model.recordDelimiter);
            fieldDelimiter(model.fieldDelimiter);
            quoteCharacter(model.quoteCharacter);
            allowQuotedRecordDelimiter(model.allowQuotedRecordDelimiter);
        }

        public final String getFileHeaderInfoAsString() {
            return fileHeaderInfo;
        }

        @Override
        public final Builder fileHeaderInfo(String fileHeaderInfo) {
            this.fileHeaderInfo = fileHeaderInfo;
            return this;
        }

        @Override
        public final Builder fileHeaderInfo(FileHeaderInfo fileHeaderInfo) {
            this.fileHeaderInfo(fileHeaderInfo.toString());
            return this;
        }

        public final void setFileHeaderInfo(String fileHeaderInfo) {
            this.fileHeaderInfo = fileHeaderInfo;
        }

        public final String getComments() {
            return comments;
        }

        @Override
        public final Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        public final void setComments(String comments) {
            this.comments = comments;
        }

        public final String getQuoteEscapeCharacter() {
            return quoteEscapeCharacter;
        }

        @Override
        public final Builder quoteEscapeCharacter(String quoteEscapeCharacter) {
            this.quoteEscapeCharacter = quoteEscapeCharacter;
            return this;
        }

        public final void setQuoteEscapeCharacter(String quoteEscapeCharacter) {
            this.quoteEscapeCharacter = quoteEscapeCharacter;
        }

        public final String getRecordDelimiter() {
            return recordDelimiter;
        }

        @Override
        public final Builder recordDelimiter(String recordDelimiter) {
            this.recordDelimiter = recordDelimiter;
            return this;
        }

        public final void setRecordDelimiter(String recordDelimiter) {
            this.recordDelimiter = recordDelimiter;
        }

        public final String getFieldDelimiter() {
            return fieldDelimiter;
        }

        @Override
        public final Builder fieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
            return this;
        }

        public final void setFieldDelimiter(String fieldDelimiter) {
            this.fieldDelimiter = fieldDelimiter;
        }

        public final String getQuoteCharacter() {
            return quoteCharacter;
        }

        @Override
        public final Builder quoteCharacter(String quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public final void setQuoteCharacter(String quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
        }

        public final Boolean getAllowQuotedRecordDelimiter() {
            return allowQuotedRecordDelimiter;
        }

        @Override
        public final Builder allowQuotedRecordDelimiter(Boolean allowQuotedRecordDelimiter) {
            this.allowQuotedRecordDelimiter = allowQuotedRecordDelimiter;
            return this;
        }

        public final void setAllowQuotedRecordDelimiter(Boolean allowQuotedRecordDelimiter) {
            this.allowQuotedRecordDelimiter = allowQuotedRecordDelimiter;
        }

        @Override
        public CSVInput build() {
            return new CSVInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
