/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information for a job's manifest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobManifest implements SdkPojo, Serializable, ToCopyableBuilder<JobManifest.Builder, JobManifest> {
    private static final SdkField<JobManifestSpec> SPEC_FIELD = SdkField
            .<JobManifestSpec> builder(MarshallingType.SDK_POJO)
            .getter(getter(JobManifest::spec))
            .setter(setter(Builder::spec))
            .constructor(JobManifestSpec::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Spec")
                    .unmarshallLocationName("Spec").build()).build();

    private static final SdkField<JobManifestLocation> LOCATION_FIELD = SdkField
            .<JobManifestLocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(JobManifest::location))
            .setter(setter(Builder::location))
            .constructor(JobManifestLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location")
                    .unmarshallLocationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEC_FIELD, LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final JobManifestSpec spec;

    private final JobManifestLocation location;

    private JobManifest(BuilderImpl builder) {
        this.spec = builder.spec;
        this.location = builder.location;
    }

    /**
     * <p>
     * Describes the format of the specified job's manifest. If the manifest is in CSV format, also describes the
     * columns contained within the manifest.
     * </p>
     * 
     * @return Describes the format of the specified job's manifest. If the manifest is in CSV format, also describes
     *         the columns contained within the manifest.
     */
    public JobManifestSpec spec() {
        return spec;
    }

    /**
     * <p>
     * Contains the information required to locate the specified job's manifest.
     * </p>
     * 
     * @return Contains the information required to locate the specified job's manifest.
     */
    public JobManifestLocation location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spec());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobManifest)) {
            return false;
        }
        JobManifest other = (JobManifest) obj;
        return Objects.equals(spec(), other.spec()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("JobManifest").add("Spec", spec()).add("Location", location()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Spec":
            return Optional.ofNullable(clazz.cast(spec()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobManifest, T> g) {
        return obj -> g.apply((JobManifest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobManifest> {
        /**
         * <p>
         * Describes the format of the specified job's manifest. If the manifest is in CSV format, also describes the
         * columns contained within the manifest.
         * </p>
         * 
         * @param spec
         *        Describes the format of the specified job's manifest. If the manifest is in CSV format, also describes
         *        the columns contained within the manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spec(JobManifestSpec spec);

        /**
         * <p>
         * Describes the format of the specified job's manifest. If the manifest is in CSV format, also describes the
         * columns contained within the manifest.
         * </p>
         * This is a convenience that creates an instance of the {@link JobManifestSpec.Builder} avoiding the need to
         * create one manually via {@link JobManifestSpec#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobManifestSpec.Builder#build()} is called immediately and its
         * result is passed to {@link #spec(JobManifestSpec)}.
         * 
         * @param spec
         *        a consumer that will call methods on {@link JobManifestSpec.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spec(JobManifestSpec)
         */
        default Builder spec(Consumer<JobManifestSpec.Builder> spec) {
            return spec(JobManifestSpec.builder().applyMutation(spec).build());
        }

        /**
         * <p>
         * Contains the information required to locate the specified job's manifest.
         * </p>
         * 
         * @param location
         *        Contains the information required to locate the specified job's manifest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(JobManifestLocation location);

        /**
         * <p>
         * Contains the information required to locate the specified job's manifest.
         * </p>
         * This is a convenience that creates an instance of the {@link JobManifestLocation.Builder} avoiding the need
         * to create one manually via {@link JobManifestLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobManifestLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #location(JobManifestLocation)}.
         * 
         * @param location
         *        a consumer that will call methods on {@link JobManifestLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #location(JobManifestLocation)
         */
        default Builder location(Consumer<JobManifestLocation.Builder> location) {
            return location(JobManifestLocation.builder().applyMutation(location).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private JobManifestSpec spec;

        private JobManifestLocation location;

        private BuilderImpl() {
        }

        private BuilderImpl(JobManifest model) {
            spec(model.spec);
            location(model.location);
        }

        public final JobManifestSpec.Builder getSpec() {
            return spec != null ? spec.toBuilder() : null;
        }

        @Override
        public final Builder spec(JobManifestSpec spec) {
            this.spec = spec;
            return this;
        }

        public final void setSpec(JobManifestSpec.BuilderImpl spec) {
            this.spec = spec != null ? spec.build() : null;
        }

        public final JobManifestLocation.Builder getLocation() {
            return location != null ? location.toBuilder() : null;
        }

        @Override
        public final Builder location(JobManifestLocation location) {
            this.location = location;
            return this;
        }

        public final void setLocation(JobManifestLocation.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public JobManifest build() {
            return new JobManifest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
