/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration parameters for a Set Object ACL operation. Amazon S3 batch operations passes each value
 * through to the underlying PUT Object acl API. For more information about the parameters for this operation, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPUTacl.html">PUT Object acl</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3SetObjectAclOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<S3SetObjectAclOperation.Builder, S3SetObjectAclOperation> {
    private static final SdkField<S3AccessControlPolicy> ACCESS_CONTROL_POLICY_FIELD = SdkField
            .<S3AccessControlPolicy> builder(MarshallingType.SDK_POJO)
            .getter(getter(S3SetObjectAclOperation::accessControlPolicy))
            .setter(setter(Builder::accessControlPolicy))
            .constructor(S3AccessControlPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlPolicy")
                    .unmarshallLocationName("AccessControlPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3AccessControlPolicy accessControlPolicy;

    private S3SetObjectAclOperation(BuilderImpl builder) {
        this.accessControlPolicy = builder.accessControlPolicy;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public S3AccessControlPolicy accessControlPolicy() {
        return accessControlPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessControlPolicy());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3SetObjectAclOperation)) {
            return false;
        }
        S3SetObjectAclOperation other = (S3SetObjectAclOperation) obj;
        return Objects.equals(accessControlPolicy(), other.accessControlPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3SetObjectAclOperation").add("AccessControlPolicy", accessControlPolicy()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessControlPolicy":
            return Optional.ofNullable(clazz.cast(accessControlPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3SetObjectAclOperation, T> g) {
        return obj -> g.apply((S3SetObjectAclOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3SetObjectAclOperation> {
        /**
         * <p/>
         * 
         * @param accessControlPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlPolicy(S3AccessControlPolicy accessControlPolicy);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link S3AccessControlPolicy.Builder} avoiding the need
         * to create one manually via {@link S3AccessControlPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3AccessControlPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #accessControlPolicy(S3AccessControlPolicy)}.
         * 
         * @param accessControlPolicy
         *        a consumer that will call methods on {@link S3AccessControlPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlPolicy(S3AccessControlPolicy)
         */
        default Builder accessControlPolicy(Consumer<S3AccessControlPolicy.Builder> accessControlPolicy) {
            return accessControlPolicy(S3AccessControlPolicy.builder().applyMutation(accessControlPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3AccessControlPolicy accessControlPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(S3SetObjectAclOperation model) {
            accessControlPolicy(model.accessControlPolicy);
        }

        public final S3AccessControlPolicy.Builder getAccessControlPolicy() {
            return accessControlPolicy != null ? accessControlPolicy.toBuilder() : null;
        }

        @Override
        public final Builder accessControlPolicy(S3AccessControlPolicy accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy;
            return this;
        }

        public final void setAccessControlPolicy(S3AccessControlPolicy.BuilderImpl accessControlPolicy) {
            this.accessControlPolicy = accessControlPolicy != null ? accessControlPolicy.build() : null;
        }

        @Override
        public S3SetObjectAclOperation build() {
            return new S3SetObjectAclOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
