/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An access point used to access a bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessPoint implements SdkPojo, Serializable, ToCopyableBuilder<AccessPoint.Builder, AccessPoint> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(AccessPoint::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> NETWORK_ORIGIN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NetworkOrigin")
            .getter(getter(AccessPoint::networkOriginAsString))
            .setter(setter(Builder::networkOrigin))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkOrigin")
                    .unmarshallLocationName("NetworkOrigin").build()).build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfiguration")
            .getter(getter(AccessPoint::vpcConfiguration))
            .setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration")
                    .unmarshallLocationName("VpcConfiguration").build()).build();

    private static final SdkField<String> BUCKET_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Bucket")
            .getter(getter(AccessPoint::bucket))
            .setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket")
                    .unmarshallLocationName("Bucket").build()).build();

    private static final SdkField<String> ACCESS_POINT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccessPointArn")
            .getter(getter(AccessPoint::accessPointArn))
            .setter(setter(Builder::accessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointArn")
                    .unmarshallLocationName("AccessPointArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            NETWORK_ORIGIN_FIELD, VPC_CONFIGURATION_FIELD, BUCKET_FIELD, ACCESS_POINT_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String networkOrigin;

    private final VpcConfiguration vpcConfiguration;

    private final String bucket;

    private final String accessPointArn;

    private AccessPoint(BuilderImpl builder) {
        this.name = builder.name;
        this.networkOrigin = builder.networkOrigin;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.bucket = builder.bucket;
        this.accessPointArn = builder.accessPointArn;
    }

    /**
     * <p>
     * The name of this access point.
     * </p>
     * 
     * @return The name of this access point.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is
     * specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point
     * doesn't allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>,
     * and the access point allows access from the public internet, subject to the access point and bucket access
     * policies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkOrigin}
     * will return {@link NetworkOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkOriginAsString}.
     * </p>
     * 
     * @return Indicates whether this access point allows access from the public internet. If
     *         <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is
     *         <code>VPC</code>, and the access point doesn't allow access from the public internet. Otherwise,
     *         <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public
     *         internet, subject to the access point and bucket access policies.
     * @see NetworkOrigin
     */
    public NetworkOrigin networkOrigin() {
        return NetworkOrigin.fromValue(networkOrigin);
    }

    /**
     * <p>
     * Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code> is
     * specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point
     * doesn't allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>,
     * and the access point allows access from the public internet, subject to the access point and bucket access
     * policies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #networkOrigin}
     * will return {@link NetworkOrigin#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkOriginAsString}.
     * </p>
     * 
     * @return Indicates whether this access point allows access from the public internet. If
     *         <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is
     *         <code>VPC</code>, and the access point doesn't allow access from the public internet. Otherwise,
     *         <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the public
     *         internet, subject to the access point and bucket access policies.
     * @see NetworkOrigin
     */
    public String networkOriginAsString() {
        return networkOrigin;
    }

    /**
     * <p>
     * The virtual private cloud (VPC) configuration for this access point, if one exists.
     * </p>
     * 
     * @return The virtual private cloud (VPC) configuration for this access point, if one exists.
     */
    public VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * The name of the bucket associated with this access point.
     * </p>
     * 
     * @return The name of the bucket associated with this access point.
     */
    public String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The ARN for the access point.
     * </p>
     * 
     * @return The ARN for the access point.
     */
    public String accessPointArn() {
        return accessPointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkOriginAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(accessPointArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPoint)) {
            return false;
        }
        AccessPoint other = (AccessPoint) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(networkOriginAsString(), other.networkOriginAsString())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration()) && Objects.equals(bucket(), other.bucket())
                && Objects.equals(accessPointArn(), other.accessPointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccessPoint").add("Name", name()).add("NetworkOrigin", networkOriginAsString())
                .add("VpcConfiguration", vpcConfiguration()).add("Bucket", bucket()).add("AccessPointArn", accessPointArn())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkOrigin":
            return Optional.ofNullable(clazz.cast(networkOriginAsString()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "AccessPointArn":
            return Optional.ofNullable(clazz.cast(accessPointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessPoint, T> g) {
        return obj -> g.apply((AccessPoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessPoint> {
        /**
         * <p>
         * The name of this access point.
         * </p>
         * 
         * @param name
         *        The name of this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code>
         * is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point
         * doesn't allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>
         * , and the access point allows access from the public internet, subject to the access point and bucket access
         * policies.
         * </p>
         * 
         * @param networkOrigin
         *        Indicates whether this access point allows access from the public internet. If
         *        <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is
         *        <code>VPC</code>, and the access point doesn't allow access from the public internet. Otherwise,
         *        <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the
         *        public internet, subject to the access point and bucket access policies.
         * @see NetworkOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkOrigin
         */
        Builder networkOrigin(String networkOrigin);

        /**
         * <p>
         * Indicates whether this access point allows access from the public internet. If <code>VpcConfiguration</code>
         * is specified for this access point, then <code>NetworkOrigin</code> is <code>VPC</code>, and the access point
         * doesn't allow access from the public internet. Otherwise, <code>NetworkOrigin</code> is <code>Internet</code>
         * , and the access point allows access from the public internet, subject to the access point and bucket access
         * policies.
         * </p>
         * 
         * @param networkOrigin
         *        Indicates whether this access point allows access from the public internet. If
         *        <code>VpcConfiguration</code> is specified for this access point, then <code>NetworkOrigin</code> is
         *        <code>VPC</code>, and the access point doesn't allow access from the public internet. Otherwise,
         *        <code>NetworkOrigin</code> is <code>Internet</code>, and the access point allows access from the
         *        public internet, subject to the access point and bucket access policies.
         * @see NetworkOrigin
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NetworkOrigin
         */
        Builder networkOrigin(NetworkOrigin networkOrigin);

        /**
         * <p>
         * The virtual private cloud (VPC) configuration for this access point, if one exists.
         * </p>
         * 
         * @param vpcConfiguration
         *        The virtual private cloud (VPC) configuration for this access point, if one exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * The virtual private cloud (VPC) configuration for this access point, if one exists.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfiguration.Builder} avoiding the need to
         * create one manually via {@link VpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * The name of the bucket associated with this access point.
         * </p>
         * 
         * @param bucket
         *        The name of the bucket associated with this access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The ARN for the access point.
         * </p>
         * 
         * @param accessPointArn
         *        The ARN for the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointArn(String accessPointArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String networkOrigin;

        private VpcConfiguration vpcConfiguration;

        private String bucket;

        private String accessPointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPoint model) {
            name(model.name);
            networkOrigin(model.networkOrigin);
            vpcConfiguration(model.vpcConfiguration);
            bucket(model.bucket);
            accessPointArn(model.accessPointArn);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getNetworkOrigin() {
            return networkOrigin;
        }

        @Override
        public final Builder networkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        @Override
        public final Builder networkOrigin(NetworkOrigin networkOrigin) {
            this.networkOrigin(networkOrigin == null ? null : networkOrigin.toString());
            return this;
        }

        public final void setNetworkOrigin(String networkOrigin) {
            this.networkOrigin = networkOrigin;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        public final String getBucket() {
            return bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public final String getAccessPointArn() {
            return accessPointArn;
        }

        @Override
        public final Builder accessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
            return this;
        }

        public final void setAccessPointArn(String accessPointArn) {
            this.accessPointArn = accessPointArn;
        }

        @Override
        public AccessPoint build() {
            return new AccessPoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
