/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessPointsResponse extends S3ControlResponse implements
        ToCopyableBuilder<ListAccessPointsResponse.Builder, ListAccessPointsResponse> {
    private static final SdkField<List<AccessPoint>> ACCESS_POINT_LIST_FIELD = SdkField
            .<List<AccessPoint>> builder(MarshallingType.LIST)
            .memberName("AccessPointList")
            .getter(getter(ListAccessPointsResponse::accessPointList))
            .setter(setter(Builder::accessPointList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointList")
                    .unmarshallLocationName("AccessPointList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("AccessPoint")
                            .memberFieldInfo(
                                    SdkField.<AccessPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AccessPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("AccessPoint").unmarshallLocationName("AccessPoint").build())
                                            .build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListAccessPointsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AccessPoint> accessPointList;

    private final String nextToken;

    private ListAccessPointsResponse(BuilderImpl builder) {
        super(builder);
        this.accessPointList = builder.accessPointList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AccessPointList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAccessPointList() {
        return accessPointList != null && !(accessPointList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains identification and configuration information for one or more access points associated with the specified
     * bucket.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccessPointList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains identification and configuration information for one or more access points associated with the
     *         specified bucket.
     */
    public List<AccessPoint> accessPointList() {
        return accessPointList;
    }

    /**
     * <p>
     * If the specified bucket has more access points than can be returned in one call to this API, this field contains
     * a continuation token that you can provide in subsequent calls to this API to retrieve additional access points.
     * </p>
     * 
     * @return If the specified bucket has more access points than can be returned in one call to this API, this field
     *         contains a continuation token that you can provide in subsequent calls to this API to retrieve additional
     *         access points.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPointList());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPointsResponse)) {
            return false;
        }
        ListAccessPointsResponse other = (ListAccessPointsResponse) obj;
        return Objects.equals(accessPointList(), other.accessPointList()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListAccessPointsResponse").add("AccessPointList", accessPointList())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPointList":
            return Optional.ofNullable(clazz.cast(accessPointList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPointsResponse, T> g) {
        return obj -> g.apply((ListAccessPointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAccessPointsResponse> {
        /**
         * <p>
         * Contains identification and configuration information for one or more access points associated with the
         * specified bucket.
         * </p>
         * 
         * @param accessPointList
         *        Contains identification and configuration information for one or more access points associated with
         *        the specified bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointList(Collection<AccessPoint> accessPointList);

        /**
         * <p>
         * Contains identification and configuration information for one or more access points associated with the
         * specified bucket.
         * </p>
         * 
         * @param accessPointList
         *        Contains identification and configuration information for one or more access points associated with
         *        the specified bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointList(AccessPoint... accessPointList);

        /**
         * <p>
         * Contains identification and configuration information for one or more access points associated with the
         * specified bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AccessPoint>.Builder} avoiding the need to
         * create one manually via {@link List<AccessPoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AccessPoint>.Builder#build()} is called immediately and its
         * result is passed to {@link #accessPointList(List<AccessPoint>)}.
         * 
         * @param accessPointList
         *        a consumer that will call methods on {@link List<AccessPoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPointList(List<AccessPoint>)
         */
        Builder accessPointList(Consumer<AccessPoint.Builder>... accessPointList);

        /**
         * <p>
         * If the specified bucket has more access points than can be returned in one call to this API, this field
         * contains a continuation token that you can provide in subsequent calls to this API to retrieve additional
         * access points.
         * </p>
         * 
         * @param nextToken
         *        If the specified bucket has more access points than can be returned in one call to this API, this
         *        field contains a continuation token that you can provide in subsequent calls to this API to retrieve
         *        additional access points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private List<AccessPoint> accessPointList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPointsResponse model) {
            super(model);
            accessPointList(model.accessPointList);
            nextToken(model.nextToken);
        }

        public final Collection<AccessPoint.Builder> getAccessPointList() {
            return accessPointList != null ? accessPointList.stream().map(AccessPoint::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder accessPointList(Collection<AccessPoint> accessPointList) {
            this.accessPointList = AccessPointListCopier.copy(accessPointList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPointList(AccessPoint... accessPointList) {
            accessPointList(Arrays.asList(accessPointList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessPointList(Consumer<AccessPoint.Builder>... accessPointList) {
            accessPointList(Stream.of(accessPointList).map(c -> AccessPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAccessPointList(Collection<AccessPoint.BuilderImpl> accessPointList) {
            this.accessPointList = AccessPointListCopier.copyFromBuilder(accessPointList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccessPointsResponse build() {
            return new ListAccessPointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
