/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3AccessControlPolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<S3AccessControlPolicy.Builder, S3AccessControlPolicy> {
    private static final SdkField<S3AccessControlList> ACCESS_CONTROL_LIST_FIELD = SdkField
            .<S3AccessControlList> builder(MarshallingType.SDK_POJO)
            .memberName("AccessControlList")
            .getter(getter(S3AccessControlPolicy::accessControlList))
            .setter(setter(Builder::accessControlList))
            .constructor(S3AccessControlList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessControlList")
                    .unmarshallLocationName("AccessControlList").build()).build();

    private static final SdkField<String> CANNED_ACCESS_CONTROL_LIST_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CannedAccessControlList")
            .getter(getter(S3AccessControlPolicy::cannedAccessControlListAsString))
            .setter(setter(Builder::cannedAccessControlList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CannedAccessControlList")
                    .unmarshallLocationName("CannedAccessControlList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_LIST_FIELD,
            CANNED_ACCESS_CONTROL_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3AccessControlList accessControlList;

    private final String cannedAccessControlList;

    private S3AccessControlPolicy(BuilderImpl builder) {
        this.accessControlList = builder.accessControlList;
        this.cannedAccessControlList = builder.cannedAccessControlList;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public S3AccessControlList accessControlList() {
        return accessControlList;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cannedAccessControlList} will return {@link S3CannedAccessControlList#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #cannedAccessControlListAsString}.
     * </p>
     * 
     * @return
     * @see S3CannedAccessControlList
     */
    public S3CannedAccessControlList cannedAccessControlList() {
        return S3CannedAccessControlList.fromValue(cannedAccessControlList);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cannedAccessControlList} will return {@link S3CannedAccessControlList#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #cannedAccessControlListAsString}.
     * </p>
     * 
     * @return
     * @see S3CannedAccessControlList
     */
    public String cannedAccessControlListAsString() {
        return cannedAccessControlList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessControlList());
        hashCode = 31 * hashCode + Objects.hashCode(cannedAccessControlListAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessControlPolicy)) {
            return false;
        }
        S3AccessControlPolicy other = (S3AccessControlPolicy) obj;
        return Objects.equals(accessControlList(), other.accessControlList())
                && Objects.equals(cannedAccessControlListAsString(), other.cannedAccessControlListAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3AccessControlPolicy").add("AccessControlList", accessControlList())
                .add("CannedAccessControlList", cannedAccessControlListAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessControlList":
            return Optional.ofNullable(clazz.cast(accessControlList()));
        case "CannedAccessControlList":
            return Optional.ofNullable(clazz.cast(cannedAccessControlListAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3AccessControlPolicy, T> g) {
        return obj -> g.apply((S3AccessControlPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3AccessControlPolicy> {
        /**
         * <p/>
         * 
         * @param accessControlList
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessControlList(S3AccessControlList accessControlList);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link S3AccessControlList.Builder} avoiding the need
         * to create one manually via {@link S3AccessControlList#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3AccessControlList.Builder#build()} is called immediately and
         * its result is passed to {@link #accessControlList(S3AccessControlList)}.
         * 
         * @param accessControlList
         *        a consumer that will call methods on {@link S3AccessControlList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessControlList(S3AccessControlList)
         */
        default Builder accessControlList(Consumer<S3AccessControlList.Builder> accessControlList) {
            return accessControlList(S3AccessControlList.builder().applyMutation(accessControlList).build());
        }

        /**
         * <p/>
         * 
         * @param cannedAccessControlList
         * @see S3CannedAccessControlList
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3CannedAccessControlList
         */
        Builder cannedAccessControlList(String cannedAccessControlList);

        /**
         * <p/>
         * 
         * @param cannedAccessControlList
         * @see S3CannedAccessControlList
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3CannedAccessControlList
         */
        Builder cannedAccessControlList(S3CannedAccessControlList cannedAccessControlList);
    }

    static final class BuilderImpl implements Builder {
        private S3AccessControlList accessControlList;

        private String cannedAccessControlList;

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessControlPolicy model) {
            accessControlList(model.accessControlList);
            cannedAccessControlList(model.cannedAccessControlList);
        }

        public final S3AccessControlList.Builder getAccessControlList() {
            return accessControlList != null ? accessControlList.toBuilder() : null;
        }

        @Override
        public final Builder accessControlList(S3AccessControlList accessControlList) {
            this.accessControlList = accessControlList;
            return this;
        }

        public final void setAccessControlList(S3AccessControlList.BuilderImpl accessControlList) {
            this.accessControlList = accessControlList != null ? accessControlList.build() : null;
        }

        public final String getCannedAccessControlList() {
            return cannedAccessControlList;
        }

        @Override
        public final Builder cannedAccessControlList(String cannedAccessControlList) {
            this.cannedAccessControlList = cannedAccessControlList;
            return this;
        }

        @Override
        public final Builder cannedAccessControlList(S3CannedAccessControlList cannedAccessControlList) {
            this.cannedAccessControlList(cannedAccessControlList == null ? null : cannedAccessControlList.toString());
            return this;
        }

        public final void setCannedAccessControlList(String cannedAccessControlList) {
            this.cannedAccessControlList = cannedAccessControlList;
        }

        @Override
        public S3AccessControlPolicy build() {
            return new S3AccessControlPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
