/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ObjectMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ObjectMetadata.Builder, S3ObjectMetadata> {
    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CacheControl")
            .getter(getter(S3ObjectMetadata::cacheControl))
            .setter(setter(Builder::cacheControl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheControl")
                    .unmarshallLocationName("CacheControl").build()).build();

    private static final SdkField<String> CONTENT_DISPOSITION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentDisposition")
            .getter(getter(S3ObjectMetadata::contentDisposition))
            .setter(setter(Builder::contentDisposition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentDisposition")
                    .unmarshallLocationName("ContentDisposition").build()).build();

    private static final SdkField<String> CONTENT_ENCODING_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentEncoding")
            .getter(getter(S3ObjectMetadata::contentEncoding))
            .setter(setter(Builder::contentEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentEncoding")
                    .unmarshallLocationName("ContentEncoding").build()).build();

    private static final SdkField<String> CONTENT_LANGUAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentLanguage")
            .getter(getter(S3ObjectMetadata::contentLanguage))
            .setter(setter(Builder::contentLanguage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentLanguage")
                    .unmarshallLocationName("ContentLanguage").build()).build();

    private static final SdkField<Map<String, String>> USER_METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("UserMetadata")
            .getter(getter(S3ObjectMetadata::userMetadata))
            .setter(setter(Builder::userMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserMetadata")
                    .unmarshallLocationName("UserMetadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").unmarshallLocationName("value").build()).build())
                            .build()).build();

    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ContentLength")
            .getter(getter(S3ObjectMetadata::contentLength))
            .setter(setter(Builder::contentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentLength")
                    .unmarshallLocationName("ContentLength").build()).build();

    private static final SdkField<String> CONTENT_MD5_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentMD5")
            .getter(getter(S3ObjectMetadata::contentMD5))
            .setter(setter(Builder::contentMD5))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentMD5")
                    .unmarshallLocationName("ContentMD5").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ContentType")
            .getter(getter(S3ObjectMetadata::contentType))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType")
                    .unmarshallLocationName("ContentType").build()).build();

    private static final SdkField<Instant> HTTP_EXPIRES_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("HttpExpiresDate")
            .getter(getter(S3ObjectMetadata::httpExpiresDate))
            .setter(setter(Builder::httpExpiresDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpExpiresDate")
                    .unmarshallLocationName("HttpExpiresDate").build()).build();

    private static final SdkField<Boolean> REQUESTER_CHARGED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequesterCharged")
            .getter(getter(S3ObjectMetadata::requesterCharged))
            .setter(setter(Builder::requesterCharged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterCharged")
                    .unmarshallLocationName("RequesterCharged").build()).build();

    private static final SdkField<String> SSE_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SSEAlgorithm")
            .getter(getter(S3ObjectMetadata::sseAlgorithmAsString))
            .setter(setter(Builder::sseAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSEAlgorithm")
                    .unmarshallLocationName("SSEAlgorithm").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CONTROL_FIELD,
            CONTENT_DISPOSITION_FIELD, CONTENT_ENCODING_FIELD, CONTENT_LANGUAGE_FIELD, USER_METADATA_FIELD, CONTENT_LENGTH_FIELD,
            CONTENT_MD5_FIELD, CONTENT_TYPE_FIELD, HTTP_EXPIRES_DATE_FIELD, REQUESTER_CHARGED_FIELD, SSE_ALGORITHM_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cacheControl;

    private final String contentDisposition;

    private final String contentEncoding;

    private final String contentLanguage;

    private final Map<String, String> userMetadata;

    private final Long contentLength;

    private final String contentMD5;

    private final String contentType;

    private final Instant httpExpiresDate;

    private final Boolean requesterCharged;

    private final String sseAlgorithm;

    private S3ObjectMetadata(BuilderImpl builder) {
        this.cacheControl = builder.cacheControl;
        this.contentDisposition = builder.contentDisposition;
        this.contentEncoding = builder.contentEncoding;
        this.contentLanguage = builder.contentLanguage;
        this.userMetadata = builder.userMetadata;
        this.contentLength = builder.contentLength;
        this.contentMD5 = builder.contentMD5;
        this.contentType = builder.contentType;
        this.httpExpiresDate = builder.httpExpiresDate;
        this.requesterCharged = builder.requesterCharged;
        this.sseAlgorithm = builder.sseAlgorithm;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String cacheControl() {
        return cacheControl;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String contentDisposition() {
        return contentDisposition;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String contentEncoding() {
        return contentEncoding;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String contentLanguage() {
        return contentLanguage;
    }

    /**
     * Returns true if the UserMetadata property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUserMetadata() {
        return userMetadata != null && !(userMetadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUserMetadata()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public Map<String, String> userMetadata() {
        return userMetadata;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Long contentLength() {
        return contentLength;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String contentMD5() {
        return contentMD5;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Instant httpExpiresDate() {
        return httpExpiresDate;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public Boolean requesterCharged() {
        return requesterCharged;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseAlgorithm} will
     * return {@link S3SSEAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseAlgorithmAsString}.
     * </p>
     * 
     * @return
     * @see S3SSEAlgorithm
     */
    public S3SSEAlgorithm sseAlgorithm() {
        return S3SSEAlgorithm.fromValue(sseAlgorithm);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sseAlgorithm} will
     * return {@link S3SSEAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sseAlgorithmAsString}.
     * </p>
     * 
     * @return
     * @see S3SSEAlgorithm
     */
    public String sseAlgorithmAsString() {
        return sseAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(contentDisposition());
        hashCode = 31 * hashCode + Objects.hashCode(contentEncoding());
        hashCode = 31 * hashCode + Objects.hashCode(contentLanguage());
        hashCode = 31 * hashCode + Objects.hashCode(userMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(contentMD5());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(httpExpiresDate());
        hashCode = 31 * hashCode + Objects.hashCode(requesterCharged());
        hashCode = 31 * hashCode + Objects.hashCode(sseAlgorithmAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ObjectMetadata)) {
            return false;
        }
        S3ObjectMetadata other = (S3ObjectMetadata) obj;
        return Objects.equals(cacheControl(), other.cacheControl())
                && Objects.equals(contentDisposition(), other.contentDisposition())
                && Objects.equals(contentEncoding(), other.contentEncoding())
                && Objects.equals(contentLanguage(), other.contentLanguage())
                && Objects.equals(userMetadata(), other.userMetadata()) && Objects.equals(contentLength(), other.contentLength())
                && Objects.equals(contentMD5(), other.contentMD5()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(httpExpiresDate(), other.httpExpiresDate())
                && Objects.equals(requesterCharged(), other.requesterCharged())
                && Objects.equals(sseAlgorithmAsString(), other.sseAlgorithmAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("S3ObjectMetadata").add("CacheControl", cacheControl())
                .add("ContentDisposition", contentDisposition()).add("ContentEncoding", contentEncoding())
                .add("ContentLanguage", contentLanguage()).add("UserMetadata", userMetadata())
                .add("ContentLength", contentLength()).add("ContentMD5", contentMD5()).add("ContentType", contentType())
                .add("HttpExpiresDate", httpExpiresDate()).add("RequesterCharged", requesterCharged())
                .add("SSEAlgorithm", sseAlgorithmAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheControl":
            return Optional.ofNullable(clazz.cast(cacheControl()));
        case "ContentDisposition":
            return Optional.ofNullable(clazz.cast(contentDisposition()));
        case "ContentEncoding":
            return Optional.ofNullable(clazz.cast(contentEncoding()));
        case "ContentLanguage":
            return Optional.ofNullable(clazz.cast(contentLanguage()));
        case "UserMetadata":
            return Optional.ofNullable(clazz.cast(userMetadata()));
        case "ContentLength":
            return Optional.ofNullable(clazz.cast(contentLength()));
        case "ContentMD5":
            return Optional.ofNullable(clazz.cast(contentMD5()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "HttpExpiresDate":
            return Optional.ofNullable(clazz.cast(httpExpiresDate()));
        case "RequesterCharged":
            return Optional.ofNullable(clazz.cast(requesterCharged()));
        case "SSEAlgorithm":
            return Optional.ofNullable(clazz.cast(sseAlgorithmAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3ObjectMetadata, T> g) {
        return obj -> g.apply((S3ObjectMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ObjectMetadata> {
        /**
         * <p/>
         * 
         * @param cacheControl
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheControl(String cacheControl);

        /**
         * <p/>
         * 
         * @param contentDisposition
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentDisposition(String contentDisposition);

        /**
         * <p/>
         * 
         * @param contentEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentEncoding(String contentEncoding);

        /**
         * <p/>
         * 
         * @param contentLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLanguage(String contentLanguage);

        /**
         * <p/>
         * 
         * @param userMetadata
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userMetadata(Map<String, String> userMetadata);

        /**
         * <p/>
         * 
         * @param contentLength
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLength(Long contentLength);

        /**
         * <p/>
         * 
         * @param contentMD5
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentMD5(String contentMD5);

        /**
         * <p/>
         * 
         * @param contentType
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p/>
         * 
         * @param httpExpiresDate
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpExpiresDate(Instant httpExpiresDate);

        /**
         * <p/>
         * 
         * @param requesterCharged
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterCharged(Boolean requesterCharged);

        /**
         * <p/>
         * 
         * @param sseAlgorithm
         * @see S3SSEAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3SSEAlgorithm
         */
        Builder sseAlgorithm(String sseAlgorithm);

        /**
         * <p/>
         * 
         * @param sseAlgorithm
         * @see S3SSEAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3SSEAlgorithm
         */
        Builder sseAlgorithm(S3SSEAlgorithm sseAlgorithm);
    }

    static final class BuilderImpl implements Builder {
        private String cacheControl;

        private String contentDisposition;

        private String contentEncoding;

        private String contentLanguage;

        private Map<String, String> userMetadata = DefaultSdkAutoConstructMap.getInstance();

        private Long contentLength;

        private String contentMD5;

        private String contentType;

        private Instant httpExpiresDate;

        private Boolean requesterCharged;

        private String sseAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ObjectMetadata model) {
            cacheControl(model.cacheControl);
            contentDisposition(model.contentDisposition);
            contentEncoding(model.contentEncoding);
            contentLanguage(model.contentLanguage);
            userMetadata(model.userMetadata);
            contentLength(model.contentLength);
            contentMD5(model.contentMD5);
            contentType(model.contentType);
            httpExpiresDate(model.httpExpiresDate);
            requesterCharged(model.requesterCharged);
            sseAlgorithm(model.sseAlgorithm);
        }

        public final String getCacheControl() {
            return cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getContentDisposition() {
            return contentDisposition;
        }

        @Override
        public final Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public final void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public final String getContentEncoding() {
            return contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public final String getContentLanguage() {
            return contentLanguage;
        }

        @Override
        public final Builder contentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
            return this;
        }

        public final void setContentLanguage(String contentLanguage) {
            this.contentLanguage = contentLanguage;
        }

        public final Map<String, String> getUserMetadata() {
            return userMetadata;
        }

        @Override
        public final Builder userMetadata(Map<String, String> userMetadata) {
            this.userMetadata = S3UserMetadataCopier.copy(userMetadata);
            return this;
        }

        public final void setUserMetadata(Map<String, String> userMetadata) {
            this.userMetadata = S3UserMetadataCopier.copy(userMetadata);
        }

        public final Long getContentLength() {
            return contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        public final String getContentMD5() {
            return contentMD5;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        public final void setContentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final Instant getHttpExpiresDate() {
            return httpExpiresDate;
        }

        @Override
        public final Builder httpExpiresDate(Instant httpExpiresDate) {
            this.httpExpiresDate = httpExpiresDate;
            return this;
        }

        public final void setHttpExpiresDate(Instant httpExpiresDate) {
            this.httpExpiresDate = httpExpiresDate;
        }

        public final Boolean getRequesterCharged() {
            return requesterCharged;
        }

        @Override
        public final Builder requesterCharged(Boolean requesterCharged) {
            this.requesterCharged = requesterCharged;
            return this;
        }

        public final void setRequesterCharged(Boolean requesterCharged) {
            this.requesterCharged = requesterCharged;
        }

        public final String getSseAlgorithm() {
            return sseAlgorithm;
        }

        @Override
        public final Builder sseAlgorithm(String sseAlgorithm) {
            this.sseAlgorithm = sseAlgorithm;
            return this;
        }

        @Override
        public final Builder sseAlgorithm(S3SSEAlgorithm sseAlgorithm) {
            this.sseAlgorithm(sseAlgorithm == null ? null : sseAlgorithm.toString());
            return this;
        }

        public final void setSseAlgorithm(String sseAlgorithm) {
            this.sseAlgorithm = sseAlgorithm;
        }

        @Override
        public S3ObjectMetadata build() {
            return new S3ObjectMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
