/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAccessPointConfigurationForObjectLambdaResponse extends S3ControlResponse
        implements
        ToCopyableBuilder<GetAccessPointConfigurationForObjectLambdaResponse.Builder, GetAccessPointConfigurationForObjectLambdaResponse> {
    private static final SdkField<ObjectLambdaConfiguration> CONFIGURATION_FIELD = SdkField
            .<ObjectLambdaConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("Configuration")
            .getter(getter(GetAccessPointConfigurationForObjectLambdaResponse::configuration))
            .setter(setter(Builder::configuration))
            .constructor(ObjectLambdaConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration")
                    .unmarshallLocationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_FIELD));

    private final ObjectLambdaConfiguration configuration;

    private GetAccessPointConfigurationForObjectLambdaResponse(BuilderImpl builder) {
        super(builder);
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * Object Lambda Access Point configuration document.
     * </p>
     * 
     * @return Object Lambda Access Point configuration document.
     */
    public final ObjectLambdaConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAccessPointConfigurationForObjectLambdaResponse)) {
            return false;
        }
        GetAccessPointConfigurationForObjectLambdaResponse other = (GetAccessPointConfigurationForObjectLambdaResponse) obj;
        return Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAccessPointConfigurationForObjectLambdaResponse").add("Configuration", configuration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAccessPointConfigurationForObjectLambdaResponse, T> g) {
        return obj -> g.apply((GetAccessPointConfigurationForObjectLambdaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAccessPointConfigurationForObjectLambdaResponse> {
        /**
         * <p>
         * Object Lambda Access Point configuration document.
         * </p>
         * 
         * @param configuration
         *        Object Lambda Access Point configuration document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(ObjectLambdaConfiguration configuration);

        /**
         * <p>
         * Object Lambda Access Point configuration document.
         * </p>
         * This is a convenience that creates an instance of the {@link ObjectLambdaConfiguration.Builder} avoiding the
         * need to create one manually via {@link ObjectLambdaConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ObjectLambdaConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #configuration(ObjectLambdaConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link ObjectLambdaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(ObjectLambdaConfiguration)
         */
        default Builder configuration(Consumer<ObjectLambdaConfiguration.Builder> configuration) {
            return configuration(ObjectLambdaConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private ObjectLambdaConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAccessPointConfigurationForObjectLambdaResponse model) {
            super(model);
            configuration(model.configuration);
        }

        public final ObjectLambdaConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(ObjectLambdaConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(ObjectLambdaConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public GetAccessPointConfigurationForObjectLambdaResponse build() {
            return new GetAccessPointConfigurationForObjectLambdaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
