/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRegionalBucketsResponse extends S3ControlResponse implements
        ToCopyableBuilder<ListRegionalBucketsResponse.Builder, ListRegionalBucketsResponse> {
    private static final SdkField<List<RegionalBucket>> REGIONAL_BUCKET_LIST_FIELD = SdkField
            .<List<RegionalBucket>> builder(MarshallingType.LIST)
            .memberName("RegionalBucketList")
            .getter(getter(ListRegionalBucketsResponse::regionalBucketList))
            .setter(setter(Builder::regionalBucketList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegionalBucketList")
                    .unmarshallLocationName("RegionalBucketList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("RegionalBucket")
                            .memberFieldInfo(
                                    SdkField.<RegionalBucket> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegionalBucket::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("RegionalBucket").unmarshallLocationName("RegionalBucket")
                                                    .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListRegionalBucketsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGIONAL_BUCKET_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<RegionalBucket> regionalBucketList;

    private final String nextToken;

    private ListRegionalBucketsResponse(BuilderImpl builder) {
        super(builder);
        this.regionalBucketList = builder.regionalBucketList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the RegionalBucketList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRegionalBucketList() {
        return regionalBucketList != null && !(regionalBucketList instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRegionalBucketList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return
     */
    public final List<RegionalBucket> regionalBucketList() {
        return regionalBucketList;
    }

    /**
     * <p>
     * <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means there are more buckets that can
     * be listed. The next list requests to Amazon S3 can be continued with this <code>NextToken</code>.
     * <code>NextToken</code> is obfuscated and is not a real key.
     * </p>
     * 
     * @return <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means there are more buckets
     *         that can be listed. The next list requests to Amazon S3 can be continued with this <code>NextToken</code>
     *         . <code>NextToken</code> is obfuscated and is not a real key.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionalBucketList() ? regionalBucketList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRegionalBucketsResponse)) {
            return false;
        }
        ListRegionalBucketsResponse other = (ListRegionalBucketsResponse) obj;
        return hasRegionalBucketList() == other.hasRegionalBucketList()
                && Objects.equals(regionalBucketList(), other.regionalBucketList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRegionalBucketsResponse")
                .add("RegionalBucketList", hasRegionalBucketList() ? regionalBucketList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RegionalBucketList":
            return Optional.ofNullable(clazz.cast(regionalBucketList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRegionalBucketsResponse, T> g) {
        return obj -> g.apply((ListRegionalBucketsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRegionalBucketsResponse> {
        /**
         * <p/>
         * 
         * @param regionalBucketList
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalBucketList(Collection<RegionalBucket> regionalBucketList);

        /**
         * <p/>
         * 
         * @param regionalBucketList
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionalBucketList(RegionalBucket... regionalBucketList);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link List<RegionalBucket>.Builder} avoiding the need
         * to create one manually via {@link List<RegionalBucket>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RegionalBucket>.Builder#build()} is called immediately and
         * its result is passed to {@link #regionalBucketList(List<RegionalBucket>)}.
         * 
         * @param regionalBucketList
         *        a consumer that will call methods on {@link List<RegionalBucket>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionalBucketList(List<RegionalBucket>)
         */
        Builder regionalBucketList(Consumer<RegionalBucket.Builder>... regionalBucketList);

        /**
         * <p>
         * <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means there are more buckets that
         * can be listed. The next list requests to Amazon S3 can be continued with this <code>NextToken</code>.
         * <code>NextToken</code> is obfuscated and is not a real key.
         * </p>
         * 
         * @param nextToken
         *        <code>NextToken</code> is sent when <code>isTruncated</code> is true, which means there are more
         *        buckets that can be listed. The next list requests to Amazon S3 can be continued with this
         *        <code>NextToken</code>. <code>NextToken</code> is obfuscated and is not a real key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private List<RegionalBucket> regionalBucketList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRegionalBucketsResponse model) {
            super(model);
            regionalBucketList(model.regionalBucketList);
            nextToken(model.nextToken);
        }

        public final Collection<RegionalBucket.Builder> getRegionalBucketList() {
            if (regionalBucketList instanceof SdkAutoConstructList) {
                return null;
            }
            return regionalBucketList != null ? regionalBucketList.stream().map(RegionalBucket::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder regionalBucketList(Collection<RegionalBucket> regionalBucketList) {
            this.regionalBucketList = RegionalBucketListCopier.copy(regionalBucketList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalBucketList(RegionalBucket... regionalBucketList) {
            regionalBucketList(Arrays.asList(regionalBucketList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regionalBucketList(Consumer<RegionalBucket.Builder>... regionalBucketList) {
            regionalBucketList(Stream.of(regionalBucketList).map(c -> RegionalBucket.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRegionalBucketList(Collection<RegionalBucket.BuilderImpl> regionalBucketList) {
            this.regionalBucketList = RegionalBucketListCopier.copyFromBuilder(regionalBucketList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListRegionalBucketsResponse build() {
            return new ListRegionalBucketsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
