/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAccessPointsForObjectLambdaResponse extends S3ControlResponse implements
        ToCopyableBuilder<ListAccessPointsForObjectLambdaResponse.Builder, ListAccessPointsForObjectLambdaResponse> {
    private static final SdkField<List<ObjectLambdaAccessPoint>> OBJECT_LAMBDA_ACCESS_POINT_LIST_FIELD = SdkField
            .<List<ObjectLambdaAccessPoint>> builder(MarshallingType.LIST)
            .memberName("ObjectLambdaAccessPointList")
            .getter(getter(ListAccessPointsForObjectLambdaResponse::objectLambdaAccessPointList))
            .setter(setter(Builder::objectLambdaAccessPointList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLambdaAccessPointList")
                    .unmarshallLocationName("ObjectLambdaAccessPointList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ObjectLambdaAccessPoint")
                            .memberFieldInfo(
                                    SdkField.<ObjectLambdaAccessPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectLambdaAccessPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ObjectLambdaAccessPoint")
                                                    .unmarshallLocationName("ObjectLambdaAccessPoint").build()).build()).build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(ListAccessPointsForObjectLambdaResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OBJECT_LAMBDA_ACCESS_POINT_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ObjectLambdaAccessPoint> objectLambdaAccessPointList;

    private final String nextToken;

    private ListAccessPointsForObjectLambdaResponse(BuilderImpl builder) {
        super(builder);
        this.objectLambdaAccessPointList = builder.objectLambdaAccessPointList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ObjectLambdaAccessPointList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasObjectLambdaAccessPointList() {
        return objectLambdaAccessPointList != null && !(objectLambdaAccessPointList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns list of Object Lambda Access Points.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasObjectLambdaAccessPointList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns list of Object Lambda Access Points.
     */
    public final List<ObjectLambdaAccessPoint> objectLambdaAccessPointList() {
        return objectLambdaAccessPointList;
    }

    /**
     * <p>
     * If the list has more access points than can be returned in one call to this API, this field contains a
     * continuation token that you can provide in subsequent calls to this API to retrieve additional access points.
     * </p>
     * 
     * @return If the list has more access points than can be returned in one call to this API, this field contains a
     *         continuation token that you can provide in subsequent calls to this API to retrieve additional access
     *         points.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectLambdaAccessPointList() ? objectLambdaAccessPointList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccessPointsForObjectLambdaResponse)) {
            return false;
        }
        ListAccessPointsForObjectLambdaResponse other = (ListAccessPointsForObjectLambdaResponse) obj;
        return hasObjectLambdaAccessPointList() == other.hasObjectLambdaAccessPointList()
                && Objects.equals(objectLambdaAccessPointList(), other.objectLambdaAccessPointList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAccessPointsForObjectLambdaResponse")
                .add("ObjectLambdaAccessPointList", hasObjectLambdaAccessPointList() ? objectLambdaAccessPointList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectLambdaAccessPointList":
            return Optional.ofNullable(clazz.cast(objectLambdaAccessPointList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAccessPointsForObjectLambdaResponse, T> g) {
        return obj -> g.apply((ListAccessPointsForObjectLambdaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAccessPointsForObjectLambdaResponse> {
        /**
         * <p>
         * Returns list of Object Lambda Access Points.
         * </p>
         * 
         * @param objectLambdaAccessPointList
         *        Returns list of Object Lambda Access Points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectLambdaAccessPointList(Collection<ObjectLambdaAccessPoint> objectLambdaAccessPointList);

        /**
         * <p>
         * Returns list of Object Lambda Access Points.
         * </p>
         * 
         * @param objectLambdaAccessPointList
         *        Returns list of Object Lambda Access Points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectLambdaAccessPointList(ObjectLambdaAccessPoint... objectLambdaAccessPointList);

        /**
         * <p>
         * Returns list of Object Lambda Access Points.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ObjectLambdaAccessPoint>.Builder} avoiding
         * the need to create one manually via {@link List<ObjectLambdaAccessPoint>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ObjectLambdaAccessPoint>.Builder#build()} is called
         * immediately and its result is passed to {@link #objectLambdaAccessPointList(List<ObjectLambdaAccessPoint>)}.
         * 
         * @param objectLambdaAccessPointList
         *        a consumer that will call methods on {@link List<ObjectLambdaAccessPoint>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #objectLambdaAccessPointList(List<ObjectLambdaAccessPoint>)
         */
        Builder objectLambdaAccessPointList(Consumer<ObjectLambdaAccessPoint.Builder>... objectLambdaAccessPointList);

        /**
         * <p>
         * If the list has more access points than can be returned in one call to this API, this field contains a
         * continuation token that you can provide in subsequent calls to this API to retrieve additional access points.
         * </p>
         * 
         * @param nextToken
         *        If the list has more access points than can be returned in one call to this API, this field contains a
         *        continuation token that you can provide in subsequent calls to this API to retrieve additional access
         *        points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private List<ObjectLambdaAccessPoint> objectLambdaAccessPointList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccessPointsForObjectLambdaResponse model) {
            super(model);
            objectLambdaAccessPointList(model.objectLambdaAccessPointList);
            nextToken(model.nextToken);
        }

        public final List<ObjectLambdaAccessPoint.Builder> getObjectLambdaAccessPointList() {
            List<ObjectLambdaAccessPoint.Builder> result = ObjectLambdaAccessPointListCopier
                    .copyToBuilder(this.objectLambdaAccessPointList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder objectLambdaAccessPointList(Collection<ObjectLambdaAccessPoint> objectLambdaAccessPointList) {
            this.objectLambdaAccessPointList = ObjectLambdaAccessPointListCopier.copy(objectLambdaAccessPointList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectLambdaAccessPointList(ObjectLambdaAccessPoint... objectLambdaAccessPointList) {
            objectLambdaAccessPointList(Arrays.asList(objectLambdaAccessPointList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectLambdaAccessPointList(Consumer<ObjectLambdaAccessPoint.Builder>... objectLambdaAccessPointList) {
            objectLambdaAccessPointList(Stream.of(objectLambdaAccessPointList)
                    .map(c -> ObjectLambdaAccessPoint.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setObjectLambdaAccessPointList(
                Collection<ObjectLambdaAccessPoint.BuilderImpl> objectLambdaAccessPointList) {
            this.objectLambdaAccessPointList = ObjectLambdaAccessPointListCopier.copyFromBuilder(objectLambdaAccessPointList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAccessPointsForObjectLambdaResponse build() {
            return new ListAccessPointsForObjectLambdaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
