/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Tagging implements SdkPojo, Serializable, ToCopyableBuilder<Tagging.Builder, Tagging> {
    private static final SdkField<List<S3Tag>> TAG_SET_FIELD = SdkField
            .<List<S3Tag>> builder(MarshallingType.LIST)
            .memberName("TagSet")
            .getter(getter(Tagging::tagSet))
            .setter(setter(Builder::tagSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("TagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<S3Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(S3Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").unmarshallLocationName("member").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<S3Tag> tagSet;

    private Tagging(BuilderImpl builder) {
        this.tagSet = builder.tagSet;
    }

    /**
     * Returns true if the TagSet property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTagSet() {
        return tagSet != null && !(tagSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A collection for a set of tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A collection for a set of tags.
     */
    public final List<S3Tag> tagSet() {
        return tagSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTagSet() ? tagSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tagging)) {
            return false;
        }
        Tagging other = (Tagging) obj;
        return hasTagSet() == other.hasTagSet() && Objects.equals(tagSet(), other.tagSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Tagging").add("TagSet", hasTagSet() ? tagSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TagSet":
            return Optional.ofNullable(clazz.cast(tagSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tagging, T> g) {
        return obj -> g.apply((Tagging) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Tagging> {
        /**
         * <p>
         * A collection for a set of tags.
         * </p>
         * 
         * @param tagSet
         *        A collection for a set of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(Collection<S3Tag> tagSet);

        /**
         * <p>
         * A collection for a set of tags.
         * </p>
         * 
         * @param tagSet
         *        A collection for a set of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagSet(S3Tag... tagSet);

        /**
         * <p>
         * A collection for a set of tags.
         * </p>
         * This is a convenience that creates an instance of the {@link List<S3Tag>.Builder} avoiding the need to create
         * one manually via {@link List<S3Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<S3Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tagSet(List<S3Tag>)}.
         * 
         * @param tagSet
         *        a consumer that will call methods on {@link List<S3Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagSet(List<S3Tag>)
         */
        Builder tagSet(Consumer<S3Tag.Builder>... tagSet);
    }

    static final class BuilderImpl implements Builder {
        private List<S3Tag> tagSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Tagging model) {
            tagSet(model.tagSet);
        }

        public final List<S3Tag.Builder> getTagSet() {
            List<S3Tag.Builder> result = S3TagSetCopier.copyToBuilder(this.tagSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tagSet(Collection<S3Tag> tagSet) {
            this.tagSet = S3TagSetCopier.copy(tagSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(S3Tag... tagSet) {
            tagSet(Arrays.asList(tagSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSet(Consumer<S3Tag.Builder>... tagSet) {
            tagSet(Stream.of(tagSet).map(c -> S3Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagSet(Collection<S3Tag.BuilderImpl> tagSet) {
            this.tagSet = S3TagSetCopier.copyFromBuilder(tagSet);
        }

        @Override
        public Tagging build() {
            return new Tagging(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
