/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the account level Amazon S3 Storage Lens configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountLevel implements SdkPojo, Serializable, ToCopyableBuilder<AccountLevel.Builder, AccountLevel> {
    private static final SdkField<ActivityMetrics> ACTIVITY_METRICS_FIELD = SdkField
            .<ActivityMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("ActivityMetrics")
            .getter(getter(AccountLevel::activityMetrics))
            .setter(setter(Builder::activityMetrics))
            .constructor(ActivityMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivityMetrics")
                    .unmarshallLocationName("ActivityMetrics").build()).build();

    private static final SdkField<BucketLevel> BUCKET_LEVEL_FIELD = SdkField
            .<BucketLevel> builder(MarshallingType.SDK_POJO)
            .memberName("BucketLevel")
            .getter(getter(AccountLevel::bucketLevel))
            .setter(setter(Builder::bucketLevel))
            .constructor(BucketLevel::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BucketLevel")
                    .unmarshallLocationName("BucketLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVITY_METRICS_FIELD,
            BUCKET_LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final ActivityMetrics activityMetrics;

    private final BucketLevel bucketLevel;

    private AccountLevel(BuilderImpl builder) {
        this.activityMetrics = builder.activityMetrics;
        this.bucketLevel = builder.bucketLevel;
    }

    /**
     * <p>
     * A container for the S3 Storage Lens activity metrics.
     * </p>
     * 
     * @return A container for the S3 Storage Lens activity metrics.
     */
    public final ActivityMetrics activityMetrics() {
        return activityMetrics;
    }

    /**
     * <p>
     * A container for the S3 Storage Lens bucket-level configuration.
     * </p>
     * 
     * @return A container for the S3 Storage Lens bucket-level configuration.
     */
    public final BucketLevel bucketLevel() {
        return bucketLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activityMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(bucketLevel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountLevel)) {
            return false;
        }
        AccountLevel other = (AccountLevel) obj;
        return Objects.equals(activityMetrics(), other.activityMetrics()) && Objects.equals(bucketLevel(), other.bucketLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountLevel").add("ActivityMetrics", activityMetrics()).add("BucketLevel", bucketLevel())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivityMetrics":
            return Optional.ofNullable(clazz.cast(activityMetrics()));
        case "BucketLevel":
            return Optional.ofNullable(clazz.cast(bucketLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountLevel, T> g) {
        return obj -> g.apply((AccountLevel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountLevel> {
        /**
         * <p>
         * A container for the S3 Storage Lens activity metrics.
         * </p>
         * 
         * @param activityMetrics
         *        A container for the S3 Storage Lens activity metrics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activityMetrics(ActivityMetrics activityMetrics);

        /**
         * <p>
         * A container for the S3 Storage Lens activity metrics.
         * </p>
         * This is a convenience that creates an instance of the {@link ActivityMetrics.Builder} avoiding the need to
         * create one manually via {@link ActivityMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link ActivityMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #activityMetrics(ActivityMetrics)}.
         * 
         * @param activityMetrics
         *        a consumer that will call methods on {@link ActivityMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activityMetrics(ActivityMetrics)
         */
        default Builder activityMetrics(Consumer<ActivityMetrics.Builder> activityMetrics) {
            return activityMetrics(ActivityMetrics.builder().applyMutation(activityMetrics).build());
        }

        /**
         * <p>
         * A container for the S3 Storage Lens bucket-level configuration.
         * </p>
         * 
         * @param bucketLevel
         *        A container for the S3 Storage Lens bucket-level configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketLevel(BucketLevel bucketLevel);

        /**
         * <p>
         * A container for the S3 Storage Lens bucket-level configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link BucketLevel.Builder} avoiding the need to create
         * one manually via {@link BucketLevel#builder()}.
         *
         * When the {@link Consumer} completes, {@link BucketLevel.Builder#build()} is called immediately and its result
         * is passed to {@link #bucketLevel(BucketLevel)}.
         * 
         * @param bucketLevel
         *        a consumer that will call methods on {@link BucketLevel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bucketLevel(BucketLevel)
         */
        default Builder bucketLevel(Consumer<BucketLevel.Builder> bucketLevel) {
            return bucketLevel(BucketLevel.builder().applyMutation(bucketLevel).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ActivityMetrics activityMetrics;

        private BucketLevel bucketLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountLevel model) {
            activityMetrics(model.activityMetrics);
            bucketLevel(model.bucketLevel);
        }

        public final ActivityMetrics.Builder getActivityMetrics() {
            return activityMetrics != null ? activityMetrics.toBuilder() : null;
        }

        public final void setActivityMetrics(ActivityMetrics.BuilderImpl activityMetrics) {
            this.activityMetrics = activityMetrics != null ? activityMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder activityMetrics(ActivityMetrics activityMetrics) {
            this.activityMetrics = activityMetrics;
            return this;
        }

        public final BucketLevel.Builder getBucketLevel() {
            return bucketLevel != null ? bucketLevel.toBuilder() : null;
        }

        public final void setBucketLevel(BucketLevel.BuilderImpl bucketLevel) {
            this.bucketLevel = bucketLevel != null ? bucketLevel.build() : null;
        }

        @Override
        @Transient
        public final Builder bucketLevel(BucketLevel bucketLevel) {
            this.bucketLevel = bucketLevel;
            return this;
        }

        @Override
        public AccountLevel build() {
            return new AccountLevel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
