/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the request parameters associated with an asynchronous request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AsyncRequestParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<AsyncRequestParameters.Builder, AsyncRequestParameters> {
    private static final SdkField<CreateMultiRegionAccessPointInput> CREATE_MULTI_REGION_ACCESS_POINT_REQUEST_FIELD = SdkField
            .<CreateMultiRegionAccessPointInput> builder(MarshallingType.SDK_POJO)
            .memberName("CreateMultiRegionAccessPointRequest")
            .getter(getter(AsyncRequestParameters::createMultiRegionAccessPointRequest))
            .setter(setter(Builder::createMultiRegionAccessPointRequest))
            .constructor(CreateMultiRegionAccessPointInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CreateMultiRegionAccessPointRequest")
                    .unmarshallLocationName("CreateMultiRegionAccessPointRequest").build()).build();

    private static final SdkField<DeleteMultiRegionAccessPointInput> DELETE_MULTI_REGION_ACCESS_POINT_REQUEST_FIELD = SdkField
            .<DeleteMultiRegionAccessPointInput> builder(MarshallingType.SDK_POJO)
            .memberName("DeleteMultiRegionAccessPointRequest")
            .getter(getter(AsyncRequestParameters::deleteMultiRegionAccessPointRequest))
            .setter(setter(Builder::deleteMultiRegionAccessPointRequest))
            .constructor(DeleteMultiRegionAccessPointInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DeleteMultiRegionAccessPointRequest")
                    .unmarshallLocationName("DeleteMultiRegionAccessPointRequest").build()).build();

    private static final SdkField<PutMultiRegionAccessPointPolicyInput> PUT_MULTI_REGION_ACCESS_POINT_POLICY_REQUEST_FIELD = SdkField
            .<PutMultiRegionAccessPointPolicyInput> builder(MarshallingType.SDK_POJO)
            .memberName("PutMultiRegionAccessPointPolicyRequest")
            .getter(getter(AsyncRequestParameters::putMultiRegionAccessPointPolicyRequest))
            .setter(setter(Builder::putMultiRegionAccessPointPolicyRequest))
            .constructor(PutMultiRegionAccessPointPolicyInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("PutMultiRegionAccessPointPolicyRequest")
                    .unmarshallLocationName("PutMultiRegionAccessPointPolicyRequest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CREATE_MULTI_REGION_ACCESS_POINT_REQUEST_FIELD, DELETE_MULTI_REGION_ACCESS_POINT_REQUEST_FIELD,
            PUT_MULTI_REGION_ACCESS_POINT_POLICY_REQUEST_FIELD));

    private static final long serialVersionUID = 1L;

    private final CreateMultiRegionAccessPointInput createMultiRegionAccessPointRequest;

    private final DeleteMultiRegionAccessPointInput deleteMultiRegionAccessPointRequest;

    private final PutMultiRegionAccessPointPolicyInput putMultiRegionAccessPointPolicyRequest;

    private AsyncRequestParameters(BuilderImpl builder) {
        this.createMultiRegionAccessPointRequest = builder.createMultiRegionAccessPointRequest;
        this.deleteMultiRegionAccessPointRequest = builder.deleteMultiRegionAccessPointRequest;
        this.putMultiRegionAccessPointPolicyRequest = builder.putMultiRegionAccessPointPolicyRequest;
    }

    /**
     * <p>
     * A container of the parameters for a <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html"
     * >CreateMultiRegionAccessPoint</a> request.
     * </p>
     * 
     * @return A container of the parameters for a <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html"
     *         >CreateMultiRegionAccessPoint</a> request.
     */
    public final CreateMultiRegionAccessPointInput createMultiRegionAccessPointRequest() {
        return createMultiRegionAccessPointRequest;
    }

    /**
     * <p>
     * A container of the parameters for a <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html"
     * >DeleteMultiRegionAccessPoint</a> request.
     * </p>
     * 
     * @return A container of the parameters for a <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html"
     *         >DeleteMultiRegionAccessPoint</a> request.
     */
    public final DeleteMultiRegionAccessPointInput deleteMultiRegionAccessPointRequest() {
        return deleteMultiRegionAccessPointRequest;
    }

    /**
     * <p>
     * A container of the parameters for a <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html"
     * >PutMultiRegionAccessPoint</a> request.
     * </p>
     * 
     * @return A container of the parameters for a <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html"
     *         >PutMultiRegionAccessPoint</a> request.
     */
    public final PutMultiRegionAccessPointPolicyInput putMultiRegionAccessPointPolicyRequest() {
        return putMultiRegionAccessPointPolicyRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createMultiRegionAccessPointRequest());
        hashCode = 31 * hashCode + Objects.hashCode(deleteMultiRegionAccessPointRequest());
        hashCode = 31 * hashCode + Objects.hashCode(putMultiRegionAccessPointPolicyRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AsyncRequestParameters)) {
            return false;
        }
        AsyncRequestParameters other = (AsyncRequestParameters) obj;
        return Objects.equals(createMultiRegionAccessPointRequest(), other.createMultiRegionAccessPointRequest())
                && Objects.equals(deleteMultiRegionAccessPointRequest(), other.deleteMultiRegionAccessPointRequest())
                && Objects.equals(putMultiRegionAccessPointPolicyRequest(), other.putMultiRegionAccessPointPolicyRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AsyncRequestParameters")
                .add("CreateMultiRegionAccessPointRequest", createMultiRegionAccessPointRequest())
                .add("DeleteMultiRegionAccessPointRequest", deleteMultiRegionAccessPointRequest())
                .add("PutMultiRegionAccessPointPolicyRequest", putMultiRegionAccessPointPolicyRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreateMultiRegionAccessPointRequest":
            return Optional.ofNullable(clazz.cast(createMultiRegionAccessPointRequest()));
        case "DeleteMultiRegionAccessPointRequest":
            return Optional.ofNullable(clazz.cast(deleteMultiRegionAccessPointRequest()));
        case "PutMultiRegionAccessPointPolicyRequest":
            return Optional.ofNullable(clazz.cast(putMultiRegionAccessPointPolicyRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AsyncRequestParameters, T> g) {
        return obj -> g.apply((AsyncRequestParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AsyncRequestParameters> {
        /**
         * <p>
         * A container of the parameters for a <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html"
         * >CreateMultiRegionAccessPoint</a> request.
         * </p>
         * 
         * @param createMultiRegionAccessPointRequest
         *        A container of the parameters for a <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html"
         *        >CreateMultiRegionAccessPoint</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createMultiRegionAccessPointRequest(CreateMultiRegionAccessPointInput createMultiRegionAccessPointRequest);

        /**
         * <p>
         * A container of the parameters for a <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateMultiRegionAccessPoint.html"
         * >CreateMultiRegionAccessPoint</a> request.
         * </p>
         * This is a convenience that creates an instance of the {@link CreateMultiRegionAccessPointInput.Builder}
         * avoiding the need to create one manually via {@link CreateMultiRegionAccessPointInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link CreateMultiRegionAccessPointInput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #createMultiRegionAccessPointRequest(CreateMultiRegionAccessPointInput)}.
         * 
         * @param createMultiRegionAccessPointRequest
         *        a consumer that will call methods on {@link CreateMultiRegionAccessPointInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createMultiRegionAccessPointRequest(CreateMultiRegionAccessPointInput)
         */
        default Builder createMultiRegionAccessPointRequest(
                Consumer<CreateMultiRegionAccessPointInput.Builder> createMultiRegionAccessPointRequest) {
            return createMultiRegionAccessPointRequest(CreateMultiRegionAccessPointInput.builder()
                    .applyMutation(createMultiRegionAccessPointRequest).build());
        }

        /**
         * <p>
         * A container of the parameters for a <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html"
         * >DeleteMultiRegionAccessPoint</a> request.
         * </p>
         * 
         * @param deleteMultiRegionAccessPointRequest
         *        A container of the parameters for a <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html"
         *        >DeleteMultiRegionAccessPoint</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteMultiRegionAccessPointRequest(DeleteMultiRegionAccessPointInput deleteMultiRegionAccessPointRequest);

        /**
         * <p>
         * A container of the parameters for a <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteMultiRegionAccessPoint.html"
         * >DeleteMultiRegionAccessPoint</a> request.
         * </p>
         * This is a convenience that creates an instance of the {@link DeleteMultiRegionAccessPointInput.Builder}
         * avoiding the need to create one manually via {@link DeleteMultiRegionAccessPointInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeleteMultiRegionAccessPointInput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #deleteMultiRegionAccessPointRequest(DeleteMultiRegionAccessPointInput)}.
         * 
         * @param deleteMultiRegionAccessPointRequest
         *        a consumer that will call methods on {@link DeleteMultiRegionAccessPointInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteMultiRegionAccessPointRequest(DeleteMultiRegionAccessPointInput)
         */
        default Builder deleteMultiRegionAccessPointRequest(
                Consumer<DeleteMultiRegionAccessPointInput.Builder> deleteMultiRegionAccessPointRequest) {
            return deleteMultiRegionAccessPointRequest(DeleteMultiRegionAccessPointInput.builder()
                    .applyMutation(deleteMultiRegionAccessPointRequest).build());
        }

        /**
         * <p>
         * A container of the parameters for a <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html"
         * >PutMultiRegionAccessPoint</a> request.
         * </p>
         * 
         * @param putMultiRegionAccessPointPolicyRequest
         *        A container of the parameters for a <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html"
         *        >PutMultiRegionAccessPoint</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder putMultiRegionAccessPointPolicyRequest(PutMultiRegionAccessPointPolicyInput putMultiRegionAccessPointPolicyRequest);

        /**
         * <p>
         * A container of the parameters for a <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutMultiRegionAccessPoint.html"
         * >PutMultiRegionAccessPoint</a> request.
         * </p>
         * This is a convenience that creates an instance of the {@link PutMultiRegionAccessPointPolicyInput.Builder}
         * avoiding the need to create one manually via {@link PutMultiRegionAccessPointPolicyInput#builder()}.
         *
         * When the {@link Consumer} completes, {@link PutMultiRegionAccessPointPolicyInput.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #putMultiRegionAccessPointPolicyRequest(PutMultiRegionAccessPointPolicyInput)}.
         * 
         * @param putMultiRegionAccessPointPolicyRequest
         *        a consumer that will call methods on {@link PutMultiRegionAccessPointPolicyInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #putMultiRegionAccessPointPolicyRequest(PutMultiRegionAccessPointPolicyInput)
         */
        default Builder putMultiRegionAccessPointPolicyRequest(
                Consumer<PutMultiRegionAccessPointPolicyInput.Builder> putMultiRegionAccessPointPolicyRequest) {
            return putMultiRegionAccessPointPolicyRequest(PutMultiRegionAccessPointPolicyInput.builder()
                    .applyMutation(putMultiRegionAccessPointPolicyRequest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CreateMultiRegionAccessPointInput createMultiRegionAccessPointRequest;

        private DeleteMultiRegionAccessPointInput deleteMultiRegionAccessPointRequest;

        private PutMultiRegionAccessPointPolicyInput putMultiRegionAccessPointPolicyRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(AsyncRequestParameters model) {
            createMultiRegionAccessPointRequest(model.createMultiRegionAccessPointRequest);
            deleteMultiRegionAccessPointRequest(model.deleteMultiRegionAccessPointRequest);
            putMultiRegionAccessPointPolicyRequest(model.putMultiRegionAccessPointPolicyRequest);
        }

        public final CreateMultiRegionAccessPointInput.Builder getCreateMultiRegionAccessPointRequest() {
            return createMultiRegionAccessPointRequest != null ? createMultiRegionAccessPointRequest.toBuilder() : null;
        }

        public final void setCreateMultiRegionAccessPointRequest(
                CreateMultiRegionAccessPointInput.BuilderImpl createMultiRegionAccessPointRequest) {
            this.createMultiRegionAccessPointRequest = createMultiRegionAccessPointRequest != null ? createMultiRegionAccessPointRequest
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder createMultiRegionAccessPointRequest(
                CreateMultiRegionAccessPointInput createMultiRegionAccessPointRequest) {
            this.createMultiRegionAccessPointRequest = createMultiRegionAccessPointRequest;
            return this;
        }

        public final DeleteMultiRegionAccessPointInput.Builder getDeleteMultiRegionAccessPointRequest() {
            return deleteMultiRegionAccessPointRequest != null ? deleteMultiRegionAccessPointRequest.toBuilder() : null;
        }

        public final void setDeleteMultiRegionAccessPointRequest(
                DeleteMultiRegionAccessPointInput.BuilderImpl deleteMultiRegionAccessPointRequest) {
            this.deleteMultiRegionAccessPointRequest = deleteMultiRegionAccessPointRequest != null ? deleteMultiRegionAccessPointRequest
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder deleteMultiRegionAccessPointRequest(
                DeleteMultiRegionAccessPointInput deleteMultiRegionAccessPointRequest) {
            this.deleteMultiRegionAccessPointRequest = deleteMultiRegionAccessPointRequest;
            return this;
        }

        public final PutMultiRegionAccessPointPolicyInput.Builder getPutMultiRegionAccessPointPolicyRequest() {
            return putMultiRegionAccessPointPolicyRequest != null ? putMultiRegionAccessPointPolicyRequest.toBuilder() : null;
        }

        public final void setPutMultiRegionAccessPointPolicyRequest(
                PutMultiRegionAccessPointPolicyInput.BuilderImpl putMultiRegionAccessPointPolicyRequest) {
            this.putMultiRegionAccessPointPolicyRequest = putMultiRegionAccessPointPolicyRequest != null ? putMultiRegionAccessPointPolicyRequest
                    .build() : null;
        }

        @Override
        @Transient
        public final Builder putMultiRegionAccessPointPolicyRequest(
                PutMultiRegionAccessPointPolicyInput putMultiRegionAccessPointPolicyRequest) {
            this.putMultiRegionAccessPointPolicyRequest = putMultiRegionAccessPointPolicyRequest;
            return this;
        }

        @Override
        public AsyncRequestParameters build() {
            return new AsyncRequestParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
