/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessPointForObjectLambdaResponse extends S3ControlResponse implements
        ToCopyableBuilder<CreateAccessPointForObjectLambdaResponse.Builder, CreateAccessPointForObjectLambdaResponse> {
    private static final SdkField<String> OBJECT_LAMBDA_ACCESS_POINT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObjectLambdaAccessPointArn")
            .getter(getter(CreateAccessPointForObjectLambdaResponse::objectLambdaAccessPointArn))
            .setter(setter(Builder::objectLambdaAccessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectLambdaAccessPointArn")
                    .unmarshallLocationName("ObjectLambdaAccessPointArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(OBJECT_LAMBDA_ACCESS_POINT_ARN_FIELD));

    private final String objectLambdaAccessPointArn;

    private CreateAccessPointForObjectLambdaResponse(BuilderImpl builder) {
        super(builder);
        this.objectLambdaAccessPointArn = builder.objectLambdaAccessPointArn;
    }

    /**
     * <p>
     * Specifies the ARN for the Object Lambda Access Point.
     * </p>
     * 
     * @return Specifies the ARN for the Object Lambda Access Point.
     */
    public final String objectLambdaAccessPointArn() {
        return objectLambdaAccessPointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(objectLambdaAccessPointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPointForObjectLambdaResponse)) {
            return false;
        }
        CreateAccessPointForObjectLambdaResponse other = (CreateAccessPointForObjectLambdaResponse) obj;
        return Objects.equals(objectLambdaAccessPointArn(), other.objectLambdaAccessPointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessPointForObjectLambdaResponse")
                .add("ObjectLambdaAccessPointArn", objectLambdaAccessPointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectLambdaAccessPointArn":
            return Optional.ofNullable(clazz.cast(objectLambdaAccessPointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPointForObjectLambdaResponse, T> g) {
        return obj -> g.apply((CreateAccessPointForObjectLambdaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccessPointForObjectLambdaResponse> {
        /**
         * <p>
         * Specifies the ARN for the Object Lambda Access Point.
         * </p>
         * 
         * @param objectLambdaAccessPointArn
         *        Specifies the ARN for the Object Lambda Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectLambdaAccessPointArn(String objectLambdaAccessPointArn);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private String objectLambdaAccessPointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPointForObjectLambdaResponse model) {
            super(model);
            objectLambdaAccessPointArn(model.objectLambdaAccessPointArn);
        }

        public final String getObjectLambdaAccessPointArn() {
            return objectLambdaAccessPointArn;
        }

        public final void setObjectLambdaAccessPointArn(String objectLambdaAccessPointArn) {
            this.objectLambdaAccessPointArn = objectLambdaAccessPointArn;
        }

        @Override
        @Transient
        public final Builder objectLambdaAccessPointArn(String objectLambdaAccessPointArn) {
            this.objectLambdaAccessPointArn = objectLambdaAccessPointArn;
            return this;
        }

        @Override
        public CreateAccessPointForObjectLambdaResponse build() {
            return new CreateAccessPointForObjectLambdaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
