/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMultiRegionAccessPointPolicyResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetMultiRegionAccessPointPolicyResponse.Builder, GetMultiRegionAccessPointPolicyResponse> {
    private static final SdkField<MultiRegionAccessPointPolicyDocument> POLICY_FIELD = SdkField
            .<MultiRegionAccessPointPolicyDocument> builder(MarshallingType.SDK_POJO)
            .memberName("Policy")
            .getter(getter(GetMultiRegionAccessPointPolicyResponse::policy))
            .setter(setter(Builder::policy))
            .constructor(MultiRegionAccessPointPolicyDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy")
                    .unmarshallLocationName("Policy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD));

    private final MultiRegionAccessPointPolicyDocument policy;

    private GetMultiRegionAccessPointPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
    }

    /**
     * <p>
     * The policy associated with the specified Multi-Region Access Point.
     * </p>
     * 
     * @return The policy associated with the specified Multi-Region Access Point.
     */
    public final MultiRegionAccessPointPolicyDocument policy() {
        return policy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMultiRegionAccessPointPolicyResponse)) {
            return false;
        }
        GetMultiRegionAccessPointPolicyResponse other = (GetMultiRegionAccessPointPolicyResponse) obj;
        return Objects.equals(policy(), other.policy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMultiRegionAccessPointPolicyResponse").add("Policy", policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMultiRegionAccessPointPolicyResponse, T> g) {
        return obj -> g.apply((GetMultiRegionAccessPointPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMultiRegionAccessPointPolicyResponse> {
        /**
         * <p>
         * The policy associated with the specified Multi-Region Access Point.
         * </p>
         * 
         * @param policy
         *        The policy associated with the specified Multi-Region Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(MultiRegionAccessPointPolicyDocument policy);

        /**
         * <p>
         * The policy associated with the specified Multi-Region Access Point.
         * </p>
         * This is a convenience that creates an instance of the {@link MultiRegionAccessPointPolicyDocument.Builder}
         * avoiding the need to create one manually via {@link MultiRegionAccessPointPolicyDocument#builder()}.
         *
         * When the {@link Consumer} completes, {@link MultiRegionAccessPointPolicyDocument.Builder#build()} is called
         * immediately and its result is passed to {@link #policy(MultiRegionAccessPointPolicyDocument)}.
         * 
         * @param policy
         *        a consumer that will call methods on {@link MultiRegionAccessPointPolicyDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policy(MultiRegionAccessPointPolicyDocument)
         */
        default Builder policy(Consumer<MultiRegionAccessPointPolicyDocument.Builder> policy) {
            return policy(MultiRegionAccessPointPolicyDocument.builder().applyMutation(policy).build());
        }
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private MultiRegionAccessPointPolicyDocument policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMultiRegionAccessPointPolicyResponse model) {
            super(model);
            policy(model.policy);
        }

        public final MultiRegionAccessPointPolicyDocument.Builder getPolicy() {
            return policy != null ? policy.toBuilder() : null;
        }

        public final void setPolicy(MultiRegionAccessPointPolicyDocument.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        @Transient
        public final Builder policy(MultiRegionAccessPointPolicyDocument policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public GetMultiRegionAccessPointPolicyResponse build() {
            return new GetMultiRegionAccessPointPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
