/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the total number of tasks that the specified job has started, the number of tasks that succeeded, and the
 * number of tasks that failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobProgressSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<JobProgressSummary.Builder, JobProgressSummary> {
    private static final SdkField<Long> TOTAL_NUMBER_OF_TASKS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumberOfTasks")
            .getter(getter(JobProgressSummary::totalNumberOfTasks))
            .setter(setter(Builder::totalNumberOfTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfTasks")
                    .unmarshallLocationName("TotalNumberOfTasks").build()).build();

    private static final SdkField<Long> NUMBER_OF_TASKS_SUCCEEDED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfTasksSucceeded")
            .getter(getter(JobProgressSummary::numberOfTasksSucceeded))
            .setter(setter(Builder::numberOfTasksSucceeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTasksSucceeded")
                    .unmarshallLocationName("NumberOfTasksSucceeded").build()).build();

    private static final SdkField<Long> NUMBER_OF_TASKS_FAILED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfTasksFailed")
            .getter(getter(JobProgressSummary::numberOfTasksFailed))
            .setter(setter(Builder::numberOfTasksFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTasksFailed")
                    .unmarshallLocationName("NumberOfTasksFailed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_NUMBER_OF_TASKS_FIELD,
            NUMBER_OF_TASKS_SUCCEEDED_FIELD, NUMBER_OF_TASKS_FAILED_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long totalNumberOfTasks;

    private final Long numberOfTasksSucceeded;

    private final Long numberOfTasksFailed;

    private JobProgressSummary(BuilderImpl builder) {
        this.totalNumberOfTasks = builder.totalNumberOfTasks;
        this.numberOfTasksSucceeded = builder.numberOfTasksSucceeded;
        this.numberOfTasksFailed = builder.numberOfTasksFailed;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long totalNumberOfTasks() {
        return totalNumberOfTasks;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long numberOfTasksSucceeded() {
        return numberOfTasksSucceeded;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long numberOfTasksFailed() {
        return numberOfTasksFailed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfTasks());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTasksSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTasksFailed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobProgressSummary)) {
            return false;
        }
        JobProgressSummary other = (JobProgressSummary) obj;
        return Objects.equals(totalNumberOfTasks(), other.totalNumberOfTasks())
                && Objects.equals(numberOfTasksSucceeded(), other.numberOfTasksSucceeded())
                && Objects.equals(numberOfTasksFailed(), other.numberOfTasksFailed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobProgressSummary").add("TotalNumberOfTasks", totalNumberOfTasks())
                .add("NumberOfTasksSucceeded", numberOfTasksSucceeded()).add("NumberOfTasksFailed", numberOfTasksFailed())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalNumberOfTasks":
            return Optional.ofNullable(clazz.cast(totalNumberOfTasks()));
        case "NumberOfTasksSucceeded":
            return Optional.ofNullable(clazz.cast(numberOfTasksSucceeded()));
        case "NumberOfTasksFailed":
            return Optional.ofNullable(clazz.cast(numberOfTasksFailed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobProgressSummary, T> g) {
        return obj -> g.apply((JobProgressSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobProgressSummary> {
        /**
         * <p/>
         * 
         * @param totalNumberOfTasks
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfTasks(Long totalNumberOfTasks);

        /**
         * <p/>
         * 
         * @param numberOfTasksSucceeded
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTasksSucceeded(Long numberOfTasksSucceeded);

        /**
         * <p/>
         * 
         * @param numberOfTasksFailed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTasksFailed(Long numberOfTasksFailed);
    }

    static final class BuilderImpl implements Builder {
        private Long totalNumberOfTasks;

        private Long numberOfTasksSucceeded;

        private Long numberOfTasksFailed;

        private BuilderImpl() {
        }

        private BuilderImpl(JobProgressSummary model) {
            totalNumberOfTasks(model.totalNumberOfTasks);
            numberOfTasksSucceeded(model.numberOfTasksSucceeded);
            numberOfTasksFailed(model.numberOfTasksFailed);
        }

        public final Long getTotalNumberOfTasks() {
            return totalNumberOfTasks;
        }

        public final void setTotalNumberOfTasks(Long totalNumberOfTasks) {
            this.totalNumberOfTasks = totalNumberOfTasks;
        }

        @Override
        @Transient
        public final Builder totalNumberOfTasks(Long totalNumberOfTasks) {
            this.totalNumberOfTasks = totalNumberOfTasks;
            return this;
        }

        public final Long getNumberOfTasksSucceeded() {
            return numberOfTasksSucceeded;
        }

        public final void setNumberOfTasksSucceeded(Long numberOfTasksSucceeded) {
            this.numberOfTasksSucceeded = numberOfTasksSucceeded;
        }

        @Override
        @Transient
        public final Builder numberOfTasksSucceeded(Long numberOfTasksSucceeded) {
            this.numberOfTasksSucceeded = numberOfTasksSucceeded;
            return this;
        }

        public final Long getNumberOfTasksFailed() {
            return numberOfTasksFailed;
        }

        public final void setNumberOfTasksFailed(Long numberOfTasksFailed) {
            this.numberOfTasksFailed = numberOfTasksFailed;
        }

        @Override
        @Transient
        public final Builder numberOfTasksFailed(Long numberOfTasksFailed) {
            this.numberOfTasksFailed = numberOfTasksFailed;
            return this;
        }

        @Override
        public JobProgressSummary build() {
            return new JobProgressSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
