/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Multi-Region Access Point access control policy.
 * </p>
 * <p>
 * When you update the policy, the update is first listed as the proposed policy. After the update is finished and all
 * Regions have been updated, the proposed policy is listed as the established policy. If both policies have the same
 * version number, the proposed policy is the established policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultiRegionAccessPointPolicyDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<MultiRegionAccessPointPolicyDocument.Builder, MultiRegionAccessPointPolicyDocument> {
    private static final SdkField<EstablishedMultiRegionAccessPointPolicy> ESTABLISHED_FIELD = SdkField
            .<EstablishedMultiRegionAccessPointPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("Established")
            .getter(getter(MultiRegionAccessPointPolicyDocument::established))
            .setter(setter(Builder::established))
            .constructor(EstablishedMultiRegionAccessPointPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Established")
                    .unmarshallLocationName("Established").build()).build();

    private static final SdkField<ProposedMultiRegionAccessPointPolicy> PROPOSED_FIELD = SdkField
            .<ProposedMultiRegionAccessPointPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("Proposed")
            .getter(getter(MultiRegionAccessPointPolicyDocument::proposed))
            .setter(setter(Builder::proposed))
            .constructor(ProposedMultiRegionAccessPointPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proposed")
                    .unmarshallLocationName("Proposed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTABLISHED_FIELD,
            PROPOSED_FIELD));

    private static final long serialVersionUID = 1L;

    private final EstablishedMultiRegionAccessPointPolicy established;

    private final ProposedMultiRegionAccessPointPolicy proposed;

    private MultiRegionAccessPointPolicyDocument(BuilderImpl builder) {
        this.established = builder.established;
        this.proposed = builder.proposed;
    }

    /**
     * <p>
     * The last established policy for the Multi-Region Access Point.
     * </p>
     * 
     * @return The last established policy for the Multi-Region Access Point.
     */
    public final EstablishedMultiRegionAccessPointPolicy established() {
        return established;
    }

    /**
     * <p>
     * The proposed policy for the Multi-Region Access Point.
     * </p>
     * 
     * @return The proposed policy for the Multi-Region Access Point.
     */
    public final ProposedMultiRegionAccessPointPolicy proposed() {
        return proposed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(established());
        hashCode = 31 * hashCode + Objects.hashCode(proposed());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultiRegionAccessPointPolicyDocument)) {
            return false;
        }
        MultiRegionAccessPointPolicyDocument other = (MultiRegionAccessPointPolicyDocument) obj;
        return Objects.equals(established(), other.established()) && Objects.equals(proposed(), other.proposed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultiRegionAccessPointPolicyDocument").add("Established", established())
                .add("Proposed", proposed()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Established":
            return Optional.ofNullable(clazz.cast(established()));
        case "Proposed":
            return Optional.ofNullable(clazz.cast(proposed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MultiRegionAccessPointPolicyDocument, T> g) {
        return obj -> g.apply((MultiRegionAccessPointPolicyDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultiRegionAccessPointPolicyDocument> {
        /**
         * <p>
         * The last established policy for the Multi-Region Access Point.
         * </p>
         * 
         * @param established
         *        The last established policy for the Multi-Region Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder established(EstablishedMultiRegionAccessPointPolicy established);

        /**
         * <p>
         * The last established policy for the Multi-Region Access Point.
         * </p>
         * This is a convenience that creates an instance of the {@link EstablishedMultiRegionAccessPointPolicy.Builder}
         * avoiding the need to create one manually via {@link EstablishedMultiRegionAccessPointPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link EstablishedMultiRegionAccessPointPolicy.Builder#build()} is
         * called immediately and its result is passed to {@link #established(EstablishedMultiRegionAccessPointPolicy)}.
         * 
         * @param established
         *        a consumer that will call methods on {@link EstablishedMultiRegionAccessPointPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #established(EstablishedMultiRegionAccessPointPolicy)
         */
        default Builder established(Consumer<EstablishedMultiRegionAccessPointPolicy.Builder> established) {
            return established(EstablishedMultiRegionAccessPointPolicy.builder().applyMutation(established).build());
        }

        /**
         * <p>
         * The proposed policy for the Multi-Region Access Point.
         * </p>
         * 
         * @param proposed
         *        The proposed policy for the Multi-Region Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposed(ProposedMultiRegionAccessPointPolicy proposed);

        /**
         * <p>
         * The proposed policy for the Multi-Region Access Point.
         * </p>
         * This is a convenience that creates an instance of the {@link ProposedMultiRegionAccessPointPolicy.Builder}
         * avoiding the need to create one manually via {@link ProposedMultiRegionAccessPointPolicy#builder()}.
         *
         * When the {@link Consumer} completes, {@link ProposedMultiRegionAccessPointPolicy.Builder#build()} is called
         * immediately and its result is passed to {@link #proposed(ProposedMultiRegionAccessPointPolicy)}.
         * 
         * @param proposed
         *        a consumer that will call methods on {@link ProposedMultiRegionAccessPointPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proposed(ProposedMultiRegionAccessPointPolicy)
         */
        default Builder proposed(Consumer<ProposedMultiRegionAccessPointPolicy.Builder> proposed) {
            return proposed(ProposedMultiRegionAccessPointPolicy.builder().applyMutation(proposed).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EstablishedMultiRegionAccessPointPolicy established;

        private ProposedMultiRegionAccessPointPolicy proposed;

        private BuilderImpl() {
        }

        private BuilderImpl(MultiRegionAccessPointPolicyDocument model) {
            established(model.established);
            proposed(model.proposed);
        }

        public final EstablishedMultiRegionAccessPointPolicy.Builder getEstablished() {
            return established != null ? established.toBuilder() : null;
        }

        public final void setEstablished(EstablishedMultiRegionAccessPointPolicy.BuilderImpl established) {
            this.established = established != null ? established.build() : null;
        }

        @Override
        @Transient
        public final Builder established(EstablishedMultiRegionAccessPointPolicy established) {
            this.established = established;
            return this;
        }

        public final ProposedMultiRegionAccessPointPolicy.Builder getProposed() {
            return proposed != null ? proposed.toBuilder() : null;
        }

        public final void setProposed(ProposedMultiRegionAccessPointPolicy.BuilderImpl proposed) {
            this.proposed = proposed != null ? proposed.build() : null;
        }

        @Override
        @Transient
        public final Builder proposed(ProposedMultiRegionAccessPointPolicy proposed) {
            this.proposed = proposed;
            return this;
        }

        @Override
        public MultiRegionAccessPointPolicyDocument build() {
            return new MultiRegionAccessPointPolicyDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
