/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for AwsLambdaTransformation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectLambdaContentTransformation implements SdkPojo, Serializable,
        ToCopyableBuilder<ObjectLambdaContentTransformation.Builder, ObjectLambdaContentTransformation> {
    private static final SdkField<AwsLambdaTransformation> AWS_LAMBDA_FIELD = SdkField
            .<AwsLambdaTransformation> builder(MarshallingType.SDK_POJO)
            .memberName("AwsLambda")
            .getter(getter(ObjectLambdaContentTransformation::awsLambda))
            .setter(setter(Builder::awsLambda))
            .constructor(AwsLambdaTransformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsLambda")
                    .unmarshallLocationName("AwsLambda").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_LAMBDA_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsLambdaTransformation awsLambda;

    private ObjectLambdaContentTransformation(BuilderImpl builder) {
        this.awsLambda = builder.awsLambda;
    }

    /**
     * <p>
     * A container for an Lambda function.
     * </p>
     * 
     * @return A container for an Lambda function.
     */
    public final AwsLambdaTransformation awsLambda() {
        return awsLambda;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(awsLambda());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectLambdaContentTransformation)) {
            return false;
        }
        ObjectLambdaContentTransformation other = (ObjectLambdaContentTransformation) obj;
        return Objects.equals(awsLambda(), other.awsLambda());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectLambdaContentTransformation").add("AwsLambda", awsLambda()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsLambda":
            return Optional.ofNullable(clazz.cast(awsLambda()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectLambdaContentTransformation, T> g) {
        return obj -> g.apply((ObjectLambdaContentTransformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectLambdaContentTransformation> {
        /**
         * <p>
         * A container for an Lambda function.
         * </p>
         * 
         * @param awsLambda
         *        A container for an Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsLambda(AwsLambdaTransformation awsLambda);

        /**
         * <p>
         * A container for an Lambda function.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsLambdaTransformation.Builder} avoiding the
         * need to create one manually via {@link AwsLambdaTransformation#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsLambdaTransformation.Builder#build()} is called immediately
         * and its result is passed to {@link #awsLambda(AwsLambdaTransformation)}.
         * 
         * @param awsLambda
         *        a consumer that will call methods on {@link AwsLambdaTransformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsLambda(AwsLambdaTransformation)
         */
        default Builder awsLambda(Consumer<AwsLambdaTransformation.Builder> awsLambda) {
            return awsLambda(AwsLambdaTransformation.builder().applyMutation(awsLambda).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsLambdaTransformation awsLambda;

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectLambdaContentTransformation model) {
            awsLambda(model.awsLambda);
        }

        public final AwsLambdaTransformation.Builder getAwsLambda() {
            return awsLambda != null ? awsLambda.toBuilder() : null;
        }

        public final void setAwsLambda(AwsLambdaTransformation.BuilderImpl awsLambda) {
            this.awsLambda = awsLambda != null ? awsLambda.build() : null;
        }

        @Override
        @Transient
        public final Builder awsLambda(AwsLambdaTransformation awsLambda) {
            this.awsLambda = awsLambda;
            return this;
        }

        @Override
        public ObjectLambdaContentTransformation build() {
            return new ObjectLambdaContentTransformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
