/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A container for the prefix-level configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrefixLevel implements SdkPojo, Serializable, ToCopyableBuilder<PrefixLevel.Builder, PrefixLevel> {
    private static final SdkField<PrefixLevelStorageMetrics> STORAGE_METRICS_FIELD = SdkField
            .<PrefixLevelStorageMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("StorageMetrics")
            .getter(getter(PrefixLevel::storageMetrics))
            .setter(setter(Builder::storageMetrics))
            .constructor(PrefixLevelStorageMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageMetrics")
                    .unmarshallLocationName("StorageMetrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_METRICS_FIELD));

    private static final long serialVersionUID = 1L;

    private final PrefixLevelStorageMetrics storageMetrics;

    private PrefixLevel(BuilderImpl builder) {
        this.storageMetrics = builder.storageMetrics;
    }

    /**
     * <p>
     * A container for the prefix-level storage metrics for S3 Storage Lens.
     * </p>
     * 
     * @return A container for the prefix-level storage metrics for S3 Storage Lens.
     */
    public final PrefixLevelStorageMetrics storageMetrics() {
        return storageMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrefixLevel)) {
            return false;
        }
        PrefixLevel other = (PrefixLevel) obj;
        return Objects.equals(storageMetrics(), other.storageMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PrefixLevel").add("StorageMetrics", storageMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StorageMetrics":
            return Optional.ofNullable(clazz.cast(storageMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrefixLevel, T> g) {
        return obj -> g.apply((PrefixLevel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrefixLevel> {
        /**
         * <p>
         * A container for the prefix-level storage metrics for S3 Storage Lens.
         * </p>
         * 
         * @param storageMetrics
         *        A container for the prefix-level storage metrics for S3 Storage Lens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageMetrics(PrefixLevelStorageMetrics storageMetrics);

        /**
         * <p>
         * A container for the prefix-level storage metrics for S3 Storage Lens.
         * </p>
         * This is a convenience that creates an instance of the {@link PrefixLevelStorageMetrics.Builder} avoiding the
         * need to create one manually via {@link PrefixLevelStorageMetrics#builder()}.
         *
         * When the {@link Consumer} completes, {@link PrefixLevelStorageMetrics.Builder#build()} is called immediately
         * and its result is passed to {@link #storageMetrics(PrefixLevelStorageMetrics)}.
         * 
         * @param storageMetrics
         *        a consumer that will call methods on {@link PrefixLevelStorageMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #storageMetrics(PrefixLevelStorageMetrics)
         */
        default Builder storageMetrics(Consumer<PrefixLevelStorageMetrics.Builder> storageMetrics) {
            return storageMetrics(PrefixLevelStorageMetrics.builder().applyMutation(storageMetrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PrefixLevelStorageMetrics storageMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(PrefixLevel model) {
            storageMetrics(model.storageMetrics);
        }

        public final PrefixLevelStorageMetrics.Builder getStorageMetrics() {
            return storageMetrics != null ? storageMetrics.toBuilder() : null;
        }

        public final void setStorageMetrics(PrefixLevelStorageMetrics.BuilderImpl storageMetrics) {
            this.storageMetrics = storageMetrics != null ? storageMetrics.build() : null;
        }

        @Override
        @Transient
        public final Builder storageMetrics(PrefixLevelStorageMetrics storageMetrics) {
            this.storageMetrics = storageMetrics;
            return this;
        }

        @Override
        public PrefixLevel build() {
            return new PrefixLevel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
