/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeJobResponse extends S3ControlResponse implements
        ToCopyableBuilder<DescribeJobResponse.Builder, DescribeJobResponse> {
    private static final SdkField<JobDescriptor> JOB_FIELD = SdkField
            .<JobDescriptor> builder(MarshallingType.SDK_POJO)
            .memberName("Job")
            .getter(getter(DescribeJobResponse::job))
            .setter(setter(Builder::job))
            .constructor(JobDescriptor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Job").unmarshallLocationName("Job")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FIELD));

    private final JobDescriptor job;

    private DescribeJobResponse(BuilderImpl builder) {
        super(builder);
        this.job = builder.job;
    }

    /**
     * <p>
     * Contains the configuration parameters and status for the job specified in the <code>Describe Job</code> request.
     * </p>
     * 
     * @return Contains the configuration parameters and status for the job specified in the <code>Describe Job</code>
     *         request.
     */
    public final JobDescriptor job() {
        return job;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(job());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobResponse)) {
            return false;
        }
        DescribeJobResponse other = (DescribeJobResponse) obj;
        return Objects.equals(job(), other.job());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeJobResponse").add("Job", job()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Job":
            return Optional.ofNullable(clazz.cast(job()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeJobResponse, T> g) {
        return obj -> g.apply((DescribeJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeJobResponse> {
        /**
         * <p>
         * Contains the configuration parameters and status for the job specified in the <code>Describe Job</code>
         * request.
         * </p>
         * 
         * @param job
         *        Contains the configuration parameters and status for the job specified in the
         *        <code>Describe Job</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder job(JobDescriptor job);

        /**
         * <p>
         * Contains the configuration parameters and status for the job specified in the <code>Describe Job</code>
         * request.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobDescriptor.Builder} avoiding the need
         * to create one manually via {@link JobDescriptor#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobDescriptor.Builder#build()} is called immediately and its
         * result is passed to {@link #job(JobDescriptor)}.
         * 
         * @param job
         *        a consumer that will call methods on {@link JobDescriptor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #job(JobDescriptor)
         */
        default Builder job(Consumer<JobDescriptor.Builder> job) {
            return job(JobDescriptor.builder().applyMutation(job).build());
        }
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private JobDescriptor job;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobResponse model) {
            super(model);
            job(model.job);
        }

        public final JobDescriptor.Builder getJob() {
            return job != null ? job.toBuilder() : null;
        }

        public final void setJob(JobDescriptor.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        @Override
        public final Builder job(JobDescriptor job) {
            this.job = job;
            return this;
        }

        @Override
        public DescribeJobResponse build() {
            return new DescribeJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
