/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetStorageLensConfigurationTaggingResponse extends S3ControlResponse implements
        ToCopyableBuilder<GetStorageLensConfigurationTaggingResponse.Builder, GetStorageLensConfigurationTaggingResponse> {
    private static final SdkField<List<StorageLensTag>> TAGS_FIELD = SdkField
            .<List<StorageLensTag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(GetStorageLensConfigurationTaggingResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<StorageLensTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(StorageLensTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").unmarshallLocationName("Tag").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD));

    private final List<StorageLensTag> tags;

    private GetStorageLensConfigurationTaggingResponse(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags of S3 Storage Lens configuration requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of S3 Storage Lens configuration requested.
     */
    public final List<StorageLensTag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetStorageLensConfigurationTaggingResponse)) {
            return false;
        }
        GetStorageLensConfigurationTaggingResponse other = (GetStorageLensConfigurationTaggingResponse) obj;
        return hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetStorageLensConfigurationTaggingResponse").add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetStorageLensConfigurationTaggingResponse, T> g) {
        return obj -> g.apply((GetStorageLensConfigurationTaggingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetStorageLensConfigurationTaggingResponse> {
        /**
         * <p>
         * The tags of S3 Storage Lens configuration requested.
         * </p>
         * 
         * @param tags
         *        The tags of S3 Storage Lens configuration requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<StorageLensTag> tags);

        /**
         * <p>
         * The tags of S3 Storage Lens configuration requested.
         * </p>
         * 
         * @param tags
         *        The tags of S3 Storage Lens configuration requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(StorageLensTag... tags);

        /**
         * <p>
         * The tags of S3 Storage Lens configuration requested.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<StorageLensTag>.Builder} avoiding
         * the need to create one manually via {@link List<StorageLensTag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<StorageLensTag>.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<StorageLensTag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<StorageLensTag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<StorageLensTag>)
         */
        Builder tags(Consumer<StorageLensTag.Builder>... tags);
    }

    static final class BuilderImpl extends S3ControlResponse.BuilderImpl implements Builder {
        private List<StorageLensTag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetStorageLensConfigurationTaggingResponse model) {
            super(model);
            tags(model.tags);
        }

        public final List<StorageLensTag.Builder> getTags() {
            List<StorageLensTag.Builder> result = StorageLensTagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<StorageLensTag.BuilderImpl> tags) {
            this.tags = StorageLensTagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<StorageLensTag> tags) {
            this.tags = StorageLensTagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(StorageLensTag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<StorageLensTag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> StorageLensTag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetStorageLensConfigurationTaggingResponse build() {
            return new GetStorageLensConfigurationTaggingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
