/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMultiRegionAccessPointOperationRequest extends S3ControlRequest implements
        ToCopyableBuilder<DescribeMultiRegionAccessPointOperationRequest.Builder, DescribeMultiRegionAccessPointOperationRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AccountId")
            .getter(getter(DescribeMultiRegionAccessPointOperationRequest::accountId))
            .setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-account-id")
                    .unmarshallLocationName("x-amz-account-id").build()).build();

    private static final SdkField<String> REQUEST_TOKEN_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RequestTokenARN")
            .getter(getter(DescribeMultiRegionAccessPointOperationRequest::requestTokenARN))
            .setter(setter(Builder::requestTokenARN))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("request_token")
                    .unmarshallLocationName("request_token").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            REQUEST_TOKEN_ARN_FIELD));

    private final String accountId;

    private final String requestTokenARN;

    private DescribeMultiRegionAccessPointOperationRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.requestTokenARN = builder.requestTokenARN;
    }

    /**
     * <p>
     * The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
     * </p>
     * 
     * @return The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The request token associated with the request you want to know about. This request token is returned as part of
     * the response when you make an asynchronous request. You provide this token to query about the status of the
     * asynchronous action.
     * </p>
     * 
     * @return The request token associated with the request you want to know about. This request token is returned as
     *         part of the response when you make an asynchronous request. You provide this token to query about the
     *         status of the asynchronous action.
     */
    public final String requestTokenARN() {
        return requestTokenARN;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(requestTokenARN());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMultiRegionAccessPointOperationRequest)) {
            return false;
        }
        DescribeMultiRegionAccessPointOperationRequest other = (DescribeMultiRegionAccessPointOperationRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(requestTokenARN(), other.requestTokenARN());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMultiRegionAccessPointOperationRequest").add("AccountId", accountId())
                .add("RequestTokenARN", requestTokenARN()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "RequestTokenARN":
            return Optional.ofNullable(clazz.cast(requestTokenARN()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMultiRegionAccessPointOperationRequest, T> g) {
        return obj -> g.apply((DescribeMultiRegionAccessPointOperationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends S3ControlRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMultiRegionAccessPointOperationRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
         * </p>
         * 
         * @param accountId
         *        The Amazon Web Services account ID for the owner of the Multi-Region Access Point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The request token associated with the request you want to know about. This request token is returned as part
         * of the response when you make an asynchronous request. You provide this token to query about the status of
         * the asynchronous action.
         * </p>
         * 
         * @param requestTokenARN
         *        The request token associated with the request you want to know about. This request token is returned
         *        as part of the response when you make an asynchronous request. You provide this token to query about
         *        the status of the asynchronous action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestTokenARN(String requestTokenARN);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends S3ControlRequest.BuilderImpl implements Builder {
        private String accountId;

        private String requestTokenARN;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMultiRegionAccessPointOperationRequest model) {
            super(model);
            accountId(model.accountId);
            requestTokenARN(model.requestTokenARN);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getRequestTokenARN() {
            return requestTokenARN;
        }

        public final void setRequestTokenARN(String requestTokenARN) {
            this.requestTokenARN = requestTokenARN;
        }

        @Override
        public final Builder requestTokenARN(String requestTokenARN) {
            this.requestTokenARN = requestTokenARN;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeMultiRegionAccessPointOperationRequest build() {
            return new DescribeMultiRegionAccessPointOperationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
