/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the type of the job's ManifestGenerator.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobManifestGenerator implements SdkPojo, Serializable,
        ToCopyableBuilder<JobManifestGenerator.Builder, JobManifestGenerator> {
    private static final SdkField<S3JobManifestGenerator> S3_JOB_MANIFEST_GENERATOR_FIELD = SdkField
            .<S3JobManifestGenerator> builder(MarshallingType.SDK_POJO)
            .memberName("S3JobManifestGenerator")
            .getter(getter(JobManifestGenerator::s3JobManifestGenerator))
            .setter(setter(Builder::s3JobManifestGenerator))
            .constructor(S3JobManifestGenerator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3JobManifestGenerator")
                    .unmarshallLocationName("S3JobManifestGenerator").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(S3_JOB_MANIFEST_GENERATOR_FIELD));

    private static final long serialVersionUID = 1L;

    private final S3JobManifestGenerator s3JobManifestGenerator;

    private final Type type;

    private JobManifestGenerator(BuilderImpl builder) {
        this.s3JobManifestGenerator = builder.s3JobManifestGenerator;
        this.type = builder.type;
    }

    /**
     * <p>
     * The S3 job ManifestGenerator's configuration details.
     * </p>
     * 
     * @return The S3 job ManifestGenerator's configuration details.
     */
    public final S3JobManifestGenerator s3JobManifestGenerator() {
        return s3JobManifestGenerator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3JobManifestGenerator());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobManifestGenerator)) {
            return false;
        }
        JobManifestGenerator other = (JobManifestGenerator) obj;
        return Objects.equals(s3JobManifestGenerator(), other.s3JobManifestGenerator());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobManifestGenerator").add("S3JobManifestGenerator", s3JobManifestGenerator()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3JobManifestGenerator":
            return Optional.ofNullable(clazz.cast(s3JobManifestGenerator()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #s3JobManifestGenerator()} initialized to the given value.
     *
     * <p>
     * The S3 job ManifestGenerator's configuration details.
     * </p>
     * 
     * @param s3JobManifestGenerator
     *        The S3 job ManifestGenerator's configuration details.
     */
    public static JobManifestGenerator fromS3JobManifestGenerator(S3JobManifestGenerator s3JobManifestGenerator) {
        return builder().s3JobManifestGenerator(s3JobManifestGenerator).build();
    }

    /**
     * Create an instance of this class with {@link #s3JobManifestGenerator()} initialized to the given value.
     *
     * <p>
     * The S3 job ManifestGenerator's configuration details.
     * </p>
     * 
     * @param s3JobManifestGenerator
     *        The S3 job ManifestGenerator's configuration details.
     */
    public static JobManifestGenerator fromS3JobManifestGenerator(Consumer<S3JobManifestGenerator.Builder> s3JobManifestGenerator) {
        S3JobManifestGenerator.Builder builder = S3JobManifestGenerator.builder();
        s3JobManifestGenerator.accept(builder);
        return fromS3JobManifestGenerator(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobManifestGenerator, T> g) {
        return obj -> g.apply((JobManifestGenerator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobManifestGenerator> {
        /**
         * <p>
         * The S3 job ManifestGenerator's configuration details.
         * </p>
         * 
         * @param s3JobManifestGenerator
         *        The S3 job ManifestGenerator's configuration details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3JobManifestGenerator(S3JobManifestGenerator s3JobManifestGenerator);

        /**
         * <p>
         * The S3 job ManifestGenerator's configuration details.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3JobManifestGenerator.Builder} avoiding
         * the need to create one manually via {@link S3JobManifestGenerator#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3JobManifestGenerator.Builder#build()} is called immediately and
         * its result is passed to {@link #s3JobManifestGenerator(S3JobManifestGenerator)}.
         * 
         * @param s3JobManifestGenerator
         *        a consumer that will call methods on {@link S3JobManifestGenerator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3JobManifestGenerator(S3JobManifestGenerator)
         */
        default Builder s3JobManifestGenerator(Consumer<S3JobManifestGenerator.Builder> s3JobManifestGenerator) {
            return s3JobManifestGenerator(S3JobManifestGenerator.builder().applyMutation(s3JobManifestGenerator).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3JobManifestGenerator s3JobManifestGenerator;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(JobManifestGenerator model) {
            s3JobManifestGenerator(model.s3JobManifestGenerator);
        }

        public final S3JobManifestGenerator.Builder getS3JobManifestGenerator() {
            return s3JobManifestGenerator != null ? s3JobManifestGenerator.toBuilder() : null;
        }

        public final void setS3JobManifestGenerator(S3JobManifestGenerator.BuilderImpl s3JobManifestGenerator) {
            Object oldValue = this.s3JobManifestGenerator;
            this.s3JobManifestGenerator = s3JobManifestGenerator != null ? s3JobManifestGenerator.build() : null;
            handleUnionValueChange(Type.S3_JOB_MANIFEST_GENERATOR, oldValue, this.s3JobManifestGenerator);
        }

        @Override
        public final Builder s3JobManifestGenerator(S3JobManifestGenerator s3JobManifestGenerator) {
            Object oldValue = this.s3JobManifestGenerator;
            this.s3JobManifestGenerator = s3JobManifestGenerator;
            handleUnionValueChange(Type.S3_JOB_MANIFEST_GENERATOR, oldValue, this.s3JobManifestGenerator);
            return this;
        }

        @Override
        public JobManifestGenerator build() {
            return new JobManifestGenerator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see JobManifestGenerator#type()
     */
    public enum Type {
        S3_JOB_MANIFEST_GENERATOR,

        UNKNOWN_TO_SDK_VERSION
    }
}
