/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3control.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the total number of tasks that the specified job has started, the number of tasks that succeeded, and the
 * number of tasks that failed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobProgressSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<JobProgressSummary.Builder, JobProgressSummary> {
    private static final SdkField<Long> TOTAL_NUMBER_OF_TASKS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("TotalNumberOfTasks")
            .getter(getter(JobProgressSummary::totalNumberOfTasks))
            .setter(setter(Builder::totalNumberOfTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfTasks")
                    .unmarshallLocationName("TotalNumberOfTasks").build()).build();

    private static final SdkField<Long> NUMBER_OF_TASKS_SUCCEEDED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfTasksSucceeded")
            .getter(getter(JobProgressSummary::numberOfTasksSucceeded))
            .setter(setter(Builder::numberOfTasksSucceeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTasksSucceeded")
                    .unmarshallLocationName("NumberOfTasksSucceeded").build()).build();

    private static final SdkField<Long> NUMBER_OF_TASKS_FAILED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfTasksFailed")
            .getter(getter(JobProgressSummary::numberOfTasksFailed))
            .setter(setter(Builder::numberOfTasksFailed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfTasksFailed")
                    .unmarshallLocationName("NumberOfTasksFailed").build()).build();

    private static final SdkField<JobTimers> TIMERS_FIELD = SdkField
            .<JobTimers> builder(MarshallingType.SDK_POJO)
            .memberName("Timers")
            .getter(getter(JobProgressSummary::timers))
            .setter(setter(Builder::timers))
            .constructor(JobTimers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timers")
                    .unmarshallLocationName("Timers").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_NUMBER_OF_TASKS_FIELD,
            NUMBER_OF_TASKS_SUCCEEDED_FIELD, NUMBER_OF_TASKS_FAILED_FIELD, TIMERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long totalNumberOfTasks;

    private final Long numberOfTasksSucceeded;

    private final Long numberOfTasksFailed;

    private final JobTimers timers;

    private JobProgressSummary(BuilderImpl builder) {
        this.totalNumberOfTasks = builder.totalNumberOfTasks;
        this.numberOfTasksSucceeded = builder.numberOfTasksSucceeded;
        this.numberOfTasksFailed = builder.numberOfTasksFailed;
        this.timers = builder.timers;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long totalNumberOfTasks() {
        return totalNumberOfTasks;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long numberOfTasksSucceeded() {
        return numberOfTasksSucceeded;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Long numberOfTasksFailed() {
        return numberOfTasksFailed;
    }

    /**
     * <p>
     * The JobTimers attribute of a job's progress summary.
     * </p>
     * 
     * @return The JobTimers attribute of a job's progress summary.
     */
    public final JobTimers timers() {
        return timers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfTasks());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTasksSucceeded());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfTasksFailed());
        hashCode = 31 * hashCode + Objects.hashCode(timers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobProgressSummary)) {
            return false;
        }
        JobProgressSummary other = (JobProgressSummary) obj;
        return Objects.equals(totalNumberOfTasks(), other.totalNumberOfTasks())
                && Objects.equals(numberOfTasksSucceeded(), other.numberOfTasksSucceeded())
                && Objects.equals(numberOfTasksFailed(), other.numberOfTasksFailed()) && Objects.equals(timers(), other.timers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobProgressSummary").add("TotalNumberOfTasks", totalNumberOfTasks())
                .add("NumberOfTasksSucceeded", numberOfTasksSucceeded()).add("NumberOfTasksFailed", numberOfTasksFailed())
                .add("Timers", timers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalNumberOfTasks":
            return Optional.ofNullable(clazz.cast(totalNumberOfTasks()));
        case "NumberOfTasksSucceeded":
            return Optional.ofNullable(clazz.cast(numberOfTasksSucceeded()));
        case "NumberOfTasksFailed":
            return Optional.ofNullable(clazz.cast(numberOfTasksFailed()));
        case "Timers":
            return Optional.ofNullable(clazz.cast(timers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobProgressSummary, T> g) {
        return obj -> g.apply((JobProgressSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobProgressSummary> {
        /**
         * <p/>
         * 
         * @param totalNumberOfTasks
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfTasks(Long totalNumberOfTasks);

        /**
         * <p/>
         * 
         * @param numberOfTasksSucceeded
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTasksSucceeded(Long numberOfTasksSucceeded);

        /**
         * <p/>
         * 
         * @param numberOfTasksFailed
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfTasksFailed(Long numberOfTasksFailed);

        /**
         * <p>
         * The JobTimers attribute of a job's progress summary.
         * </p>
         * 
         * @param timers
         *        The JobTimers attribute of a job's progress summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timers(JobTimers timers);

        /**
         * <p>
         * The JobTimers attribute of a job's progress summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobTimers.Builder} avoiding the need to
         * create one manually via {@link JobTimers#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobTimers.Builder#build()} is called immediately and its result
         * is passed to {@link #timers(JobTimers)}.
         * 
         * @param timers
         *        a consumer that will call methods on {@link JobTimers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timers(JobTimers)
         */
        default Builder timers(Consumer<JobTimers.Builder> timers) {
            return timers(JobTimers.builder().applyMutation(timers).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long totalNumberOfTasks;

        private Long numberOfTasksSucceeded;

        private Long numberOfTasksFailed;

        private JobTimers timers;

        private BuilderImpl() {
        }

        private BuilderImpl(JobProgressSummary model) {
            totalNumberOfTasks(model.totalNumberOfTasks);
            numberOfTasksSucceeded(model.numberOfTasksSucceeded);
            numberOfTasksFailed(model.numberOfTasksFailed);
            timers(model.timers);
        }

        public final Long getTotalNumberOfTasks() {
            return totalNumberOfTasks;
        }

        public final void setTotalNumberOfTasks(Long totalNumberOfTasks) {
            this.totalNumberOfTasks = totalNumberOfTasks;
        }

        @Override
        public final Builder totalNumberOfTasks(Long totalNumberOfTasks) {
            this.totalNumberOfTasks = totalNumberOfTasks;
            return this;
        }

        public final Long getNumberOfTasksSucceeded() {
            return numberOfTasksSucceeded;
        }

        public final void setNumberOfTasksSucceeded(Long numberOfTasksSucceeded) {
            this.numberOfTasksSucceeded = numberOfTasksSucceeded;
        }

        @Override
        public final Builder numberOfTasksSucceeded(Long numberOfTasksSucceeded) {
            this.numberOfTasksSucceeded = numberOfTasksSucceeded;
            return this;
        }

        public final Long getNumberOfTasksFailed() {
            return numberOfTasksFailed;
        }

        public final void setNumberOfTasksFailed(Long numberOfTasksFailed) {
            this.numberOfTasksFailed = numberOfTasksFailed;
        }

        @Override
        public final Builder numberOfTasksFailed(Long numberOfTasksFailed) {
            this.numberOfTasksFailed = numberOfTasksFailed;
            return this;
        }

        public final JobTimers.Builder getTimers() {
            return timers != null ? timers.toBuilder() : null;
        }

        public final void setTimers(JobTimers.BuilderImpl timers) {
            this.timers = timers != null ? timers.build() : null;
        }

        @Override
        public final Builder timers(JobTimers timers) {
            this.timers = timers;
            return this;
        }

        @Override
        public JobProgressSummary build() {
            return new JobProgressSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
